/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.brainfuck4j.memory;

import de.florianmichael.brainfuck4j.exception.BFRuntimeException;
import de.florianmichael.brainfuck4j.language.Instruction;
import de.florianmichael.brainfuck4j.language.InstructionTypes;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.List;

public abstract class AMemory {
    public final int size;
    public int currentPointer;

    public AMemory(int size) {
        this.size = size;
    }

    public void execute(InputStreamReader in, PrintStream out, List<Instruction> instructions, short[] loopPoints) throws Throwable {
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            if (instruction.type == InstructionTypes.INCREASE_MEMORY_POINTER) {
                if (this.currentPointer < this.size - 1) {
                    this.currentPointer += instruction.count;
                    continue;
                }
                throw new BFRuntimeException(BFRuntimeException.Type.MEMORY_OVERFLOW);
            }
            if (instruction.type == InstructionTypes.DECREASE_MEMORY_POINTER) {
                if (this.currentPointer != 0) {
                    this.currentPointer -= instruction.count;
                    continue;
                }
                throw new BFRuntimeException(BFRuntimeException.Type.MEMORY_UNDERFLOW);
            }
            i = this.handleInstruction(in, out, instruction.type, instruction.count, i, loopPoints);
        }
    }

    public abstract int handleInstruction(InputStreamReader var1, PrintStream var2, InstructionTypes var3, int var4, int var5, short[] var6) throws Throwable;
}

