/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.brainfuck4j.language;

public enum InstructionTypes {
    INCREASE_VALUE(Character.valueOf('+')),
    DECREASE_VALUE(Character.valueOf('-')),
    INCREASE_MEMORY_POINTER(Character.valueOf('>')),
    DECREASE_MEMORY_POINTER(Character.valueOf('<')),
    START_LOOP(Character.valueOf('[')),
    END_LOOP(Character.valueOf(']')),
    GET_CHAR(Character.valueOf('.')),
    PUT_CHAR(Character.valueOf(',')),
    CLEAR_LOOP(null);

    public final Character leadingCharacter;

    private InstructionTypes(Character leadingCharacter) {
        this.leadingCharacter = leadingCharacter;
    }

    public static InstructionTypes fromLeadingCharacter(char character) {
        for (InstructionTypes value : InstructionTypes.values()) {
            if (value.leadingCharacter == null || value.leadingCharacter.charValue() != character) continue;
            return value;
        }
        return null;
    }
}

