/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.brainfuck4j.language;

import java.util.HashMap;
import java.util.Map;

public class Dialect {
    public static Dialect BRAINFUCK = new Dialect("Brainfuck", ">", "<", "+", "-", "[", "]", ",", ".");
    public static Dialect TROLLSCRIPT = new Dialect("Trollscript", "ooo", "ool", "olo", "oll", "loo", "lol", "llo", "lll");
    public static Dialect OOK = new Dialect("Ook!", "Ook. Ook?", "Ook? Ook.", "Ook. Ook.", "Ook! Ook!", "Ook! Ook.", "Ook. Ook!", "Ook! Ook?", "Ook? Ook!");
    public final String name;
    public final String increase_memory_pointer;
    public final String decrease_memory_pointer;
    public final String increase_value;
    public final String decrease_value;
    public final String start_loop;
    public final String end_loop;
    public final String get_char;
    public final String put_char;

    public Dialect(String name, String increase_memory_pointer, String decrease_memory_pointer, String increase_value, String decrease_value, String start_loop, String end_loop, String get_char, String put_char) {
        this.name = name;
        this.increase_memory_pointer = increase_memory_pointer;
        this.decrease_memory_pointer = decrease_memory_pointer;
        this.increase_value = increase_value;
        this.decrease_value = decrease_value;
        this.start_loop = start_loop;
        this.end_loop = end_loop;
        this.get_char = get_char;
        this.put_char = put_char;
    }

    public static String convert(String input, Dialect from, Dialect to) {
        HashMap<String, String> diff = new HashMap<String, String>();
        diff.put(from.increase_memory_pointer, to.increase_memory_pointer);
        diff.put(from.decrease_memory_pointer, from.decrease_memory_pointer);
        diff.put(from.increase_value, to.increase_value);
        diff.put(from.decrease_value, from.decrease_value);
        diff.put(from.start_loop, to.start_loop);
        diff.put(from.end_loop, from.end_loop);
        diff.put(from.get_char, to.get_char);
        diff.put(from.put_char, from.put_char);
        StringBuilder output = new StringBuilder();
        while (!input.isEmpty()) {
            int count = 1;
            for (Map.Entry entry : diff.entrySet()) {
                if (!input.startsWith((String)entry.getKey())) continue;
                output.append((String)entry.getValue());
                count = ((String)entry.getKey()).length();
                break;
            }
            input = input.substring(count);
        }
        return output.toString();
    }

    public String toString() {
        return "Dialect{name='" + this.name + "', increase_memory_pointer='" + this.increase_memory_pointer + "', decrease_memory_pointer='" + this.decrease_memory_pointer + "', increase_value='" + this.increase_value + "', decrease_value='" + this.decrease_value + "', start_while_loop='" + this.start_loop + "', if_condition_and_jump_back='" + this.end_loop + "', get_char='" + this.get_char + "', put_char='" + this.put_char + "'}";
    }
}

