/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.brainfuck4j;

import de.florianmichael.brainfuck4j.exception.BFRuntimeException;
import de.florianmichael.brainfuck4j.language.Instruction;
import de.florianmichael.brainfuck4j.language.InstructionTypes;
import de.florianmichael.brainfuck4j.memory.AMemory;
import de.florianmichael.brainfuck4j.util.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class Brainfuck4J {
    private final Logger logger;
    private final Runnable finished;
    public short[] loopPoints;

    public Brainfuck4J() {
        this(null);
    }

    public Brainfuck4J(Runnable finished) {
        this(new Logger.LoggerImpl(), finished);
    }

    public Brainfuck4J(Logger logger, Runnable finished) {
        this.logger = logger;
        this.finished = finished;
    }

    public void close() {
        if (this.finished == null) {
            return;
        }
        this.finished.run();
    }

    private List<Instruction> batch(List<InstructionTypes> instructionTypes) {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        InstructionTypes last = null;
        for (InstructionTypes type : instructionTypes) {
            if (instructions.isEmpty() || type == InstructionTypes.START_LOOP || type == InstructionTypes.END_LOOP || type == InstructionTypes.GET_CHAR || type == InstructionTypes.PUT_CHAR) {
                instructions.add(new Instruction(type));
                last = type;
                continue;
            }
            if (last == type) {
                ((Instruction)instructions.get(instructions.size() - 1)).increment();
            } else {
                instructions.add(new Instruction(type));
            }
            last = type;
        }
        return instructions;
    }

    private List<InstructionTypes> clearLoops(List<InstructionTypes> instructions) {
        ArrayList<InstructionTypes> newInstructions = new ArrayList<InstructionTypes>();
        for (int i = 0; i < instructions.size(); ++i) {
            InstructionTypes old = instructions.get(i);
            if (instructions.size() - 1 > i + 2) {
                InstructionTypes operator = instructions.get(i + 1);
                if (old == InstructionTypes.START_LOOP && (operator == InstructionTypes.INCREASE_VALUE || operator == InstructionTypes.DECREASE_VALUE) && instructions.get(i + 2) == InstructionTypes.END_LOOP) {
                    newInstructions.add(InstructionTypes.CLEAR_LOOP);
                    i += 2;
                    continue;
                }
            }
            newInstructions.add(old);
        }
        return newInstructions;
    }

    private void calculateLoopPoints(List<Instruction> instructions) {
        this.loopPoints = new short[instructions.size()];
        short end = (short)(instructions.size() - 1);
        int in = 0;
        for (Instruction instruction : instructions) {
            if (instruction.type == InstructionTypes.START_LOOP) {
                ++in;
            }
            if (instruction.type == InstructionTypes.END_LOOP) {
                --in;
            }
            if (in >= 0) continue;
            break;
        }
        if (in != 0) {
            throw new BFRuntimeException(BFRuntimeException.Type.INVALID_LOOK_SYNTAX);
        }
        block1: for (short start = 0; start < end; start = (short)(start + 1)) {
            if (instructions.get((int)start).type != InstructionTypes.START_LOOP) continue;
            in = 0;
            for (short i = (short)(start + 1); i <= end; i = (short)(i + 1)) {
                if (instructions.get((int)i).type == InstructionTypes.END_LOOP) {
                    if (in <= 0) {
                        this.loopPoints[start] = i;
                        this.loopPoints[i] = start;
                        continue block1;
                    }
                    --in;
                    continue;
                }
                if (instructions.get((int)i).type != InstructionTypes.START_LOOP) continue;
                ++in;
            }
        }
    }

    public void run(InputStream in, PrintStream out, AMemory memory, String input) {
        try {
            char[] code;
            long time = System.currentTimeMillis();
            ArrayList<InstructionTypes> instructionTypes = new ArrayList<InstructionTypes>();
            for (char c : code = input.toCharArray()) {
                InstructionTypes type = InstructionTypes.fromLeadingCharacter(c);
                if (type == null) continue;
                instructionTypes.add(type);
            }
            List<Instruction> instructions = this.batch(this.clearLoops(instructionTypes));
            this.calculateLoopPoints(instructions);
            InputStreamReader inIO = new InputStreamReader(in);
            PrintStream outIO = new PrintStream(out);
            memory.execute(inIO, outIO, instructions, this.loopPoints);
            this.close();
            this.logger.info("Instruction count: " + instructions.size() + " | Time: " + (System.currentTimeMillis() - time) + "ms");
        }
        catch (Throwable e) {
            this.logger.error(e);
            this.close();
        }
    }
}

