/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.asmfabricloader.loader.feature.classtransform;

import de.florianmichael.asmfabricloader.loader.classloading.AFLConstants;
import de.florianmichael.asmfabricloader.loader.classloading.MixinClassLoaderConstants;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.impl.launch.knot.Knot;
import net.lenni0451.classtransform.InjectionCallback;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.mappings.AMapper;
import net.lenni0451.classtransform.utils.tree.BasicClassProvider;
import net.lenni0451.classtransform.utils.tree.IClassProvider;
import net.lenni0451.reflect.ClassLoaders;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class MixinTransformerBootstrap {
    private static final List<TransformerManager> TRANSFORMER = new ArrayList<TransformerManager>();

    public static ClassNode transform(String mixinClassName, ClassNode mixin) {
        ClassWriter writer = new ClassWriter(1);
        mixin.accept((ClassVisitor)writer);
        byte[] current = writer.toByteArray();
        for (TransformerManager manager : TRANSFORMER) {
            byte[] transformed = manager.transform(mixinClassName, current);
            if (transformed == null) continue;
            current = transformed;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(current);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    static {
        BasicClassProvider classProvider = new BasicClassProvider(Knot.getLauncher().getTargetClassLoader());
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            try {
                ClassLoaders.defineClass((ClassLoader)ClassLoader.getSystemClassLoader(), (String)InjectionCallback.class.getName(), (byte[])classProvider.getClass(InjectionCallback.class.getName()));
            }
            catch (ClassNotFoundException e) {
                AFLConstants.LOGGER.error("Unable to load InjectionCallback class", (Throwable)e);
            }
        }
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            List<String> mixingTransformers = MixinClassLoaderConstants.MIXING_TRANSFORMERS.get(mod);
            if (mixingTransformers == null) continue;
            AMapper mapper = MixinClassLoaderConstants.getMapper(mod);
            TransformerManager manager = new TransformerManager((IClassProvider)classProvider, mapper);
            for (String transformer : mixingTransformers) {
                manager.addTransformer(transformer);
            }
            TRANSFORMER.add(manager);
        }
        MixinClassLoaderConstants.MIXING_TRANSFORMERS.clear();
    }
}

