/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.asmfabricloader.loader.feature;

import com.google.gson.Gson;
import de.florianmichael.asmfabricloader.api.EarlyRiser;
import de.florianmichael.asmfabricloader.api.event.InstrumentationEntrypoint;
import de.florianmichael.asmfabricloader.loader.AFLFeature;
import de.florianmichael.asmfabricloader.loader.classloading.AFLConstants;
import de.florianmichael.asmfabricloader.loader.classloading.MixinClassLoaderConstants;
import de.florianmichael.asmfabricloader.loader.feature.classtransform.ClassTransformJson;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.utils.tree.BasicClassProvider;
import net.lenni0451.classtransform.utils.tree.IClassProvider;
import net.lenni0451.reflect.Agents;

public final class ClassTransform {
    private final Gson GSON = new Gson();
    private final Map<ModContainer, List<ClassTransformJson>> modsToTransformerJsons = new HashMap<ModContainer, List<ClassTransformJson>>();
    private final Map<ModContainer, TransformerManager> modsToJavaTransformers = new HashMap<ModContainer, TransformerManager>();

    public ClassTransform(Collection<ModContainer> modContainers) {
        AFLFeature.applyForMods(modContainers, "classtransform", (modContainer, value) -> {
            try {
                for (CustomValue transformerValue : value.getAsArray()) {
                    this.parseTransformer((ModContainer)modContainer, transformerValue.getAsString());
                }
            }
            catch (Exception e) {
                this.parseTransformer((ModContainer)modContainer, value.getAsString());
            }
        });
        if (AFLConstants.isDebugEnabled()) {
            AFLConstants.LOGGER.info("Loaded {} transformer config{}", (Object)this.modsToTransformerJsons.size(), (Object)(this.modsToTransformerJsons.size() != 1 ? "s" : ""));
        }
        for (Map.Entry<ModContainer, List<ClassTransformJson>> entry : this.modsToTransformerJsons.entrySet()) {
            ModContainer mod = entry.getKey();
            TransformerManager manager = new TransformerManager((IClassProvider)new BasicClassProvider(), MixinClassLoaderConstants.getMapper(mod));
            for (ClassTransformJson config : entry.getValue()) {
                for (String transformer : config.javaTransformers()) {
                    manager.addTransformer(config.packageName() + "." + transformer);
                }
            }
            this.modsToJavaTransformers.put(mod, manager);
        }
        try {
            Instrumentation instrumentation = Agents.getInstrumentation();
            EarlyRiser.invokeEntrypoints(InstrumentationEntrypoint.getEntrypointName(), InstrumentationEntrypoint.class, entrypoint -> entrypoint.onGetInstrumentation(instrumentation));
            for (TransformerManager manager : this.modsToJavaTransformers.values()) {
                manager.hookInstrumentation(instrumentation);
            }
            AFLConstants.LOGGER.error("KnotClassLoader, you fool! You fell victim to one of the classic blunders!");
        }
        catch (Exception e) {
            AFLConstants.LOGGER.error("Failed to hook instrumentation", (Throwable)e);
        }
    }

    private void parseTransformer(ModContainer mod, String filePath) {
        if (!filePath.endsWith(".json")) {
            AFLConstants.LOGGER.error("Transformer config file {} from {} is not a json file", (Object)filePath, (Object)mod.getMetadata().getId());
            return;
        }
        mod.findPath(filePath).ifPresentOrElse(path -> {
            try {
                String content = Files.readString(path);
                ClassTransformJson config = (ClassTransformJson)this.GSON.fromJson(content, ClassTransformJson.class);
                this.modsToTransformerJsons.computeIfAbsent(mod, modContainer -> new ArrayList()).add(config);
                ArrayList<CallSite> mixinTransformers = new ArrayList<CallSite>();
                for (String mixinTransformer : config.mixinTransformers()) {
                    mixinTransformers.add((CallSite)((Object)(config.packageName() + "." + mixinTransformer)));
                }
                MixinClassLoaderConstants.MIXING_TRANSFORMERS.put(mod, mixinTransformers);
            }
            catch (IOException e) {
                AFLConstants.LOGGER.error("Failed to read transformer config file {} from {}", (Object)filePath, (Object)mod.getMetadata().getId(), (Object)e);
            }
        }, () -> AFLConstants.LOGGER.error("Transformer config file {} from {} does not exist", (Object)filePath, (Object)mod.getMetadata().getId()));
    }

    public boolean hasJavaTransformers(ModContainer mod) {
        return this.modsToJavaTransformers.containsKey(mod);
    }

    public void registerJavaTransformer(ModContainer mod, String folder, String ... paths) throws IllegalArgumentException {
        TransformerManager transformerManager = this.modsToJavaTransformers.get(mod);
        if (transformerManager == null) {
            throw new IllegalArgumentException("Mod " + mod.getMetadata().getId() + " is not transforming classes");
        }
        for (String path : paths) {
            transformerManager.addTransformer(folder + "." + path);
        }
    }

    public void registerJavaTransformer(ModContainer mod, String path) throws IllegalArgumentException {
        TransformerManager transformerManager = this.modsToJavaTransformers.get(mod);
        if (transformerManager == null) {
            throw new IllegalArgumentException("Mod " + mod.getMetadata().getId() + " is not transforming classes");
        }
        transformerManager.addTransformer(path);
    }

    public boolean isTransforming(ModContainer mod) {
        return this.modsToTransformerJsons.containsKey(mod);
    }

    public List<ClassTransformJson> getTransformers(ModContainer mod) throws IllegalArgumentException {
        if (!this.modsToTransformerJsons.containsKey(mod)) {
            throw new IllegalArgumentException("Mod " + mod.getMetadata().getId() + " is not transforming classes");
        }
        return this.modsToTransformerJsons.get(mod);
    }

    public int getTransformerCount(ModContainer mod, boolean java, boolean mixin) throws IllegalArgumentException {
        if (!this.modsToTransformerJsons.containsKey(mod)) {
            throw new IllegalArgumentException("Mod " + mod.getMetadata().getId() + " is not transforming classes");
        }
        int sum = 0;
        for (ClassTransformJson classTransformJson : this.modsToTransformerJsons.get(mod)) {
            if (java) {
                sum += classTransformJson.javaTransformers().size();
            }
            if (!mixin) continue;
            sum += classTransformJson.mixinTransformers().size();
        }
        return sum;
    }

    public int getAllTransformerCount(boolean java, boolean mixin) {
        return this.getAllTransformers(java, mixin).size();
    }

    public List<String> getAllTransformers(boolean java, boolean mixin) {
        ArrayList<String> transformers = new ArrayList<String>();
        for (List<ClassTransformJson> value : this.modsToTransformerJsons.values()) {
            for (ClassTransformJson classTransformJson : value) {
                if (java) {
                    transformers.addAll(classTransformJson.javaTransformers());
                }
                if (!mixin) continue;
                transformers.addAll(classTransformJson.mixinTransformers());
            }
        }
        return transformers;
    }

    public TransformerManager getJavaTransformerManager(ModContainer mod) {
        return this.modsToJavaTransformers.get(mod);
    }
}

