/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.asmfabricloader.loader.classloading;

import de.florianmichael.asmfabricloader.loader.AFLFeature;
import de.florianmichael.asmfabricloader.loader.classloading.AFLConstants;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.lenni0451.classtransform.mappings.AMapper;
import net.lenni0451.classtransform.mappings.MapperConfig;
import net.lenni0451.classtransform.mappings.impl.TinyV2Mapper;
import net.lenni0451.classtransform.mappings.impl.VoidMapper;

public class MixinClassLoaderConstants {
    public static final Map<ModContainer, List<String>> MIXING_TRANSFORMERS = new ConcurrentHashMap<ModContainer, List<String>>();
    private static final Map<ModContainer, AMapper> MOD_MAPPINGS = new ConcurrentHashMap<ModContainer, AMapper>();
    private static final String DEFAULT_MAPPINGS_PATH = "/afl_mappings.tiny";

    public static AMapper getMapper(ModContainer mod) {
        return MOD_MAPPINGS.computeIfAbsent(mod, id -> {
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                return new VoidMapper();
            }
            Optional mappingsPath = mod.findPath(MixinClassLoaderConstants.getConfiguredMappingsPath(mod));
            if (mappingsPath.isEmpty()) {
                return new VoidMapper();
            }
            String modId = mod.getMetadata().getId();
            Path sourcePath = (Path)mappingsPath.get();
            try {
                Path tempFile = Files.createTempFile("afl_mappings_" + modId + "_", ".tiny", new FileAttribute[0]);
                try (InputStream in = Files.newInputStream(sourcePath, new OpenOption[0]);){
                    Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
                }
                tempFile.toFile().deleteOnExit();
                AFLConstants.LOGGER.info("Loaded AFL mappings for mod {} from {}", (Object)modId, (Object)sourcePath);
                return new TinyV2Mapper(MapperConfig.create().fillSuperMappings(true).remapTransformer(true), tempFile.toFile(), "named", "intermediary");
            }
            catch (IOException e) {
                AFLConstants.LOGGER.error("I/O error while loading afl mappings for mod {} from {}", (Object)modId, (Object)sourcePath, (Object)e);
                return new VoidMapper();
            }
            catch (Throwable t) {
                AFLConstants.LOGGER.error("Failed to load afl mappings for mod {} from {}", (Object)modId, (Object)sourcePath, (Object)t);
                return new VoidMapper();
            }
        });
    }

    private static String getConfiguredMappingsPath(ModContainer mod) {
        CustomValue value = AFLFeature.getAflFeature(mod, "mappings_path");
        if (value == null) {
            return DEFAULT_MAPPINGS_PATH;
        }
        try {
            String path = value.getAsString().trim();
            return path.startsWith("/") ? path : "/" + path;
        }
        catch (Exception e) {
            AFLConstants.LOGGER.warn("Invalid custom.asmfabricloader:mappings on mod {}: {}", (Object)mod.getMetadata().getId(), (Object)e.getMessage());
            return DEFAULT_MAPPINGS_PATH;
        }
    }
}

