/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.asmfabricloader;

import de.florianmichael.asmfabricloader.api.EarlyRiser;
import de.florianmichael.asmfabricloader.api.event.PrePrePreLaunchEntrypoint;
import de.florianmichael.asmfabricloader.loader.classloading.AFLConstants;
import de.florianmichael.asmfabricloader.loader.feature.ClassTransform;
import de.florianmichael.asmfabricloader.loader.feature.JarBooter;
import de.florianmichael.asmfabricloader.loader.feature.Unmixer;
import java.util.Collection;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class AsmFabricLoader {
    private static AsmFabricLoader loader;
    private final ClassTransform classTransform;
    private final Unmixer unmixer;
    private final JarBooter jarBooter;

    public static void install() {
        if (loader != null) {
            throw new IllegalStateException("AsmFabricLoader is already installed");
        }
        AFLConstants.LOGGER.error("no good? no, this man is definitely up to evil.");
        loader = new AsmFabricLoader();
    }

    public AsmFabricLoader() {
        EarlyRiser.invokeEntrypoints(PrePrePreLaunchEntrypoint.getEntrypointName(), PrePrePreLaunchEntrypoint.class, PrePrePreLaunchEntrypoint::onLanguageAdapterLaunch);
        Collection mods = FabricLoader.getInstance().getAllMods();
        this.classTransform = new ClassTransform(mods);
        this.unmixer = new Unmixer(mods);
        this.jarBooter = new JarBooter(mods);
    }

    public List<ModContainer> getAflMods() {
        return FabricLoader.getInstance().getAllMods().stream().filter(this::isAflMod).toList();
    }

    public boolean isAflMod(ModContainer mod) {
        return mod.getMetadata().getCustomValues().keySet().stream().anyMatch(s -> s.startsWith("afl:"));
    }

    public ClassTransform getClassTransform() {
        return this.classTransform;
    }

    public Unmixer getUnmixer() {
        return this.unmixer;
    }

    public JarBooter getJarBooter() {
        return this.jarBooter;
    }

    public static AsmFabricLoader getLoader() {
        return loader;
    }
}

