/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.asmfabricloader.loader.feature.classtransform;

import de.florianmichael.asmfabricloader.loader.classloading.AFLConstants;
import de.florianmichael.asmfabricloader.loader.classloading.MixinClassLoaderConstants;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.launch.knot.Knot;
import net.lenni0451.classtransform.InjectionCallback;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.utils.tree.BasicClassProvider;
import net.lenni0451.classtransform.utils.tree.IClassProvider;
import net.lenni0451.reflect.ClassLoaders;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class MixinTransformerBootstrap {
    private static final TransformerManager TRANSFORMER;

    public static ClassNode transform(String mixinClassName, ClassNode mixin) {
        ClassWriter writer = new ClassWriter(1);
        mixin.accept((ClassVisitor)writer);
        byte[] newBytes = TRANSFORMER.transform(mixinClassName, writer.toByteArray());
        if (newBytes == null) {
            return mixin;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(newBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    static {
        BasicClassProvider classProvider = new BasicClassProvider(Knot.getLauncher().getTargetClassLoader());
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            try {
                ClassLoaders.defineClass((ClassLoader)ClassLoader.getSystemClassLoader(), (String)InjectionCallback.class.getName(), (byte[])classProvider.getClass(InjectionCallback.class.getName()));
            }
            catch (ClassNotFoundException e) {
                AFLConstants.LOGGER.error("Unable to load InjectionCallback class", (Throwable)e);
            }
        }
        TRANSFORMER = new TransformerManager((IClassProvider)classProvider, MixinClassLoaderConstants.MAPPINGS);
        for (String transformer : MixinClassLoaderConstants.MIXING_TRANSFORMERS) {
            TRANSFORMER.addTransformer(transformer);
        }
        MixinClassLoaderConstants.MIXING_TRANSFORMERS.clear();
    }
}

