/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.asmfabricloader.loader.feature;

import de.florianmichael.asmfabricloader.loader.AFLFeature;
import de.florianmichael.asmfabricloader.loader.classloading.AFLConstants;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.lenni0451.reflect.ClassLoaders;
import net.lenni0451.reflect.stream.RStream;

public class JarBooter {
    public JarBooter(Collection<ModContainer> modContainers) {
        AFLFeature.applyForMods(modContainers, "jarbooter", (modContainer, value) -> {
            if (value.getType() == CustomValue.CvType.ARRAY) {
                for (CustomValue customValue : value.getAsArray()) {
                    File target = new File(customValue.getAsString());
                    this.replaceJar(target);
                }
            } else if (value.getType() == CustomValue.CvType.STRING) {
                File target = new File(value.getAsString());
                this.replaceJar(target);
            }
        });
    }

    public void replaceJar(File file) {
        try {
            this.replaceJar0(file);
        }
        catch (MalformedURLException e) {
            AFLConstants.LOGGER.error("Failed to load jar file {} to the front of the classpath", (Object)file.getName(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceJar0(File file) throws MalformedURLException {
        for (File listFile : file.listFiles()) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader actualLoader = (ClassLoader)RStream.of((Object)oldLoader).fields().by("urlLoader").get();
                Thread.currentThread().setContextClassLoader(actualLoader);
                if (listFile.getName().endsWith(".jar")) {
                    ClassLoaders.loadToFront((URL)listFile.toURI().toURL());
                    if (!AFLConstants.isDebugEnabled()) continue;
                    AFLConstants.LOGGER.info("Loaded jar file {} to the front of the classpath", (Object)listFile.getName());
                    continue;
                }
                if (!listFile.isDirectory()) continue;
                this.replaceJar0(listFile);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }
}

