/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.asmfabricloader.api;

import de.florianmichael.asmfabricloader.loader.classloading.AFLConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.LanguageAdapterException;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.impl.metadata.EntrypointMetadata;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.fabricmc.loader.impl.util.DefaultLanguageAdapter;

public class EarlyRiser {
    public static <T> void invokeEntrypoints(String name, Class<T> type, Consumer<T> consumer) {
        EarlyRiser.getEarlyEntrypoints(name, type).forEach(consumer);
    }

    public static <T> List<T> getEarlyEntrypoints(String name, Class<T> type) {
        ArrayList<T> entrypoints = new ArrayList<T>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata modMetadata = mod.getMetadata();
            if (!(modMetadata instanceof LoaderModMetadata)) continue;
            LoaderModMetadata modMetadata2 = (LoaderModMetadata)modMetadata;
            List entrypointMetadata = modMetadata2.getEntrypoints(name);
            for (EntrypointMetadata metadata : entrypointMetadata) {
                T entrypoint = EarlyRiser.createEntrypoint(mod, metadata.getValue(), type);
                if (entrypoint == null) continue;
                entrypoints.add(entrypoint);
            }
        }
        return entrypoints;
    }

    public static <T> T createEntrypoint(ModContainer mod, String value, Class<T> type) {
        try {
            return (T)DefaultLanguageAdapter.INSTANCE.create(mod, value, type);
        }
        catch (LanguageAdapterException e) {
            AFLConstants.LOGGER.error("Failed to load early entrypoint {} for mod {}", (Object)value, (Object)mod.getMetadata().getId(), (Object)e);
            return null;
        }
    }
}

