/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.asmfabricloader.loader.feature;

import com.google.gson.Gson;
import de.florianmichael.asmfabricloader.api.EarlyRiser;
import de.florianmichael.asmfabricloader.api.event.InstrumentationEntrypoint;
import de.florianmichael.asmfabricloader.loader.AFLFeature;
import de.florianmichael.asmfabricloader.loader.classloading.AFLConstants;
import de.florianmichael.asmfabricloader.loader.classloading.MixinClassLoaderConstants;
import de.florianmichael.asmfabricloader.loader.feature.classtransform.ClassTransformJson;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.utils.tree.BasicClassProvider;
import net.lenni0451.classtransform.utils.tree.IClassProvider;
import net.lenni0451.reflect.Agents;

public final class ClassTransform {
    private final Gson GSON = new Gson();
    private final Map<ModContainer, List<ClassTransformJson>> modsToTransformerJsons = new HashMap<ModContainer, List<ClassTransformJson>>();
    private final TransformerManager javaTransformerManager;

    public ClassTransform(Collection<ModContainer> modContainers) {
        AFLFeature.applyForMods(modContainers, "classtransform", (modContainer, value) -> {
            try {
                for (CustomValue transformerValue : value.getAsArray()) {
                    this.parseTransformer((ModContainer)modContainer, transformerValue.getAsString());
                }
            }
            catch (Exception e) {
                this.parseTransformer((ModContainer)modContainer, value.getAsString());
            }
        });
        if (AFLConstants.isDebugEnabled()) {
            AFLConstants.LOGGER.info("Loaded {} transformer config{}", (Object)this.modsToTransformerJsons.size(), (Object)(this.modsToTransformerJsons.size() != 1 ? "s" : ""));
        }
        this.javaTransformerManager = new TransformerManager((IClassProvider)new BasicClassProvider(), MixinClassLoaderConstants.MAPPINGS);
        for (List<ClassTransformJson> value2 : this.modsToTransformerJsons.values()) {
            for (ClassTransformJson config : value2) {
                for (String transformer : config.javaTransformers()) {
                    this.javaTransformerManager.addTransformer(config.packageName() + "." + transformer);
                }
            }
        }
        try {
            Instrumentation instrumentation = Agents.getInstrumentation();
            EarlyRiser.invokeEntrypoints(InstrumentationEntrypoint.getEntrypointName(), InstrumentationEntrypoint.class, entrypoint -> entrypoint.onGetInstrumentation(instrumentation));
            this.javaTransformerManager.hookInstrumentation(instrumentation);
            AFLConstants.LOGGER.error("KnotClassLoader, you fool! You fell victim to one of the classic blunders!");
        }
        catch (Exception e) {
            AFLConstants.LOGGER.error("Failed to hook instrumentation", (Throwable)e);
        }
    }

    private void parseTransformer(ModContainer provider, String filePath) {
        if (!filePath.endsWith(".json")) {
            AFLConstants.LOGGER.error("Transformer config file {} from {} is not a json file", (Object)filePath, (Object)provider.getMetadata().getId());
            return;
        }
        provider.findPath(filePath).ifPresentOrElse(path -> {
            try {
                String content = Files.readString(path);
                ClassTransformJson config = (ClassTransformJson)this.GSON.fromJson(content, ClassTransformJson.class);
                this.modsToTransformerJsons.computeIfAbsent(provider, modContainer -> new ArrayList()).add(config);
                for (String mixinTransformer : config.mixinTransformers()) {
                    MixinClassLoaderConstants.MIXING_TRANSFORMERS.add(config.packageName() + "." + mixinTransformer);
                }
            }
            catch (IOException e) {
                AFLConstants.LOGGER.error("Failed to read transformer config file {} from {}", (Object)filePath, (Object)provider.getMetadata().getId(), (Object)e);
            }
        }, () -> AFLConstants.LOGGER.error("Transformer config file {} from {} does not exist", (Object)filePath, (Object)provider.getMetadata().getId()));
    }

    public void registerJavaTransformer(String folder, String ... paths) {
        for (String path : paths) {
            this.javaTransformerManager.addTransformer(folder + "." + path);
        }
    }

    public void registerJavaTransformer(String path) {
        this.javaTransformerManager.addTransformer(path);
    }

    public boolean isTransforming(ModContainer mod) {
        return this.modsToTransformerJsons.containsKey(mod);
    }

    public List<ClassTransformJson> getTransformers(ModContainer mod) {
        if (!this.modsToTransformerJsons.containsKey(mod)) {
            return null;
        }
        return this.modsToTransformerJsons.get(mod);
    }

    public int getTransformerCount(ModContainer mod, boolean java, boolean mixin) {
        if (!this.modsToTransformerJsons.containsKey(mod)) {
            return 0;
        }
        int sum = 0;
        for (ClassTransformJson classTransformJson : this.modsToTransformerJsons.get(mod)) {
            if (java) {
                sum += classTransformJson.javaTransformers().size();
            }
            if (!mixin) continue;
            sum += classTransformJson.mixinTransformers().size();
        }
        return sum;
    }

    public int getAllTransformerCount(boolean java, boolean mixin) {
        return this.getAllTransformers(java, mixin).size();
    }

    public List<String> getAllTransformers(boolean java, boolean mixin) {
        ArrayList<String> transformers = new ArrayList<String>();
        for (List<ClassTransformJson> value : this.modsToTransformerJsons.values()) {
            for (ClassTransformJson classTransformJson : value) {
                if (java) {
                    transformers.addAll(classTransformJson.javaTransformers());
                }
                if (!mixin) continue;
                transformers.addAll(classTransformJson.mixinTransformers());
            }
        }
        return transformers;
    }

    public TransformerManager getJavaTransformerManager() {
        return this.javaTransformerManager;
    }
}

