/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.asmfabricloader.loader.feature;

import de.florianmichael.asmfabricloader.loader.AFLFeature;
import de.florianmichael.asmfabricloader.loader.classloading.AFLConstants;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.lenni0451.reflect.stream.RStream;

public class Unmixer {
    public static final String class_MIXINCONFIG = "org.spongepowered.asm.mixin.transformer.MixinConfig";
    public static final String field_MIXINCONFIG_globalMixinList = "globalMixinList";

    public Unmixer(Collection<ModContainer> modContainers) {
        AFLFeature.applyForMods(modContainers, "unmixer", (modContainer, value) -> {
            if (value.getType() == CustomValue.CvType.ARRAY) {
                for (CustomValue customValue : value.getAsArray()) {
                    this.unloadMixinClass(customValue.getAsString());
                }
            } else {
                for (Map.Entry entry : value.getAsObject()) {
                    if (((CustomValue)entry.getValue()).getType() != CustomValue.CvType.ARRAY) continue;
                    String packageName = (String)entry.getKey();
                    for (CustomValue customValue : ((CustomValue)entry.getValue()).getAsArray()) {
                        this.unloadMixinClass(packageName + "." + customValue.getAsString());
                    }
                }
            }
        });
    }

    public void unloadMixinClass(String folder, String ... mixins) {
        for (String mixin : mixins) {
            this.unloadMixinClass(folder + "." + mixin);
        }
    }

    public void unloadMixinClass(String path) {
        Set mixins = (Set)RStream.of((String)class_MIXINCONFIG).fields().by(field_MIXINCONFIG_globalMixinList).get();
        mixins.add(path);
        if (AFLConstants.isDebugEnabled()) {
            AFLConstants.LOGGER.warn("Unloaded mixin class " + path);
        }
    }
}

