/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.asmfabricloader.api;

import de.florianmichael.asmfabricloader.api.AsmUtil;
import java.util.List;
import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.FieldDef;
import net.fabricmc.mapping.tree.MethodDef;
import net.fabricmc.mapping.tree.TinyTree;

public class MapperBase {
    private final TinyTree mappings;
    private final String from;
    private final String to;

    public MapperBase(TinyTree mappings, String from, String to) {
        this.mappings = mappings;
        this.from = from;
        this.to = to;
    }

    public String getClassName(String from) {
        ClassDef classDef = this.getClassDef(from);
        if (classDef == null) {
            return from;
        }
        return classDef.getName(this.to);
    }

    public ClassDef getClassDef(String name) {
        for (ClassDef classDef : this.mappings.getClasses()) {
            if (!classDef.getName("intermediary").equals(name) && !classDef.getName("named").equals(name)) continue;
            return classDef;
        }
        return null;
    }

    public String getMethodName(Class<?> owner, String from) {
        MethodDef methodDef = this.getMethodDef(owner, from, true);
        if (methodDef == null) {
            return from;
        }
        return methodDef.getName(this.to);
    }

    public MethodDef getMethodDef(Class<?> owner, String name, boolean superclasses) {
        List<String> classNames = superclasses ? AsmUtil.getClassStruct(owner) : List.of(AsmUtil.normalizeDescriptor(owner.getName()));
        for (String className : classNames) {
            ClassDef classDef = this.getClassDef(className);
            if (classDef == null) continue;
            for (MethodDef method : classDef.getMethods()) {
                if (!method.getName(this.from).equals(name)) continue;
                return method;
            }
        }
        return null;
    }

    public String getFieldName(Class<?> owner, String from) {
        FieldDef fieldDef = this.getFieldDef(owner, from, true);
        if (fieldDef == null) {
            return from;
        }
        return fieldDef.getName(this.to);
    }

    public FieldDef getFieldDef(Class<?> owner, String name, boolean superclasses) {
        List<String> classNames = superclasses ? AsmUtil.getClassStruct(owner) : List.of(AsmUtil.normalizeDescriptor(owner.getName()));
        for (String className : classNames) {
            ClassDef classDef = this.getClassDef(className);
            if (classDef == null) continue;
            for (FieldDef field : classDef.getFields()) {
                if (!field.getName(this.from).equals(name)) continue;
                return field;
            }
        }
        return null;
    }
}

