/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.sprout.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class SproutServiceGenerator {
    private static final ClassName LIST = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
    private static final ClassName OPTIONAL = ClassName.get((String)"java.util", (String)"Optional", (String[])new String[0]);
    private static final ClassName OVERRIDE = ClassName.get(Override.class);
    private static final ClassName BEAN_UTILS = ClassName.get((String)"org.springframework.beans", (String)"BeanUtils", (String[])new String[0]);
    private static final ClassName SERVICE = ClassName.get((String)"org.springframework.stereotype", (String)"Service", (String[])new String[0]);
    private static final ClassName TRANSACTIONAL = ClassName.get((String)"org.springframework.transaction.annotation", (String)"Transactional", (String[])new String[0]);

    private SproutServiceGenerator() {
    }

    protected static TypeSpec.Builder generateService(TypeElement type, String simpleName, String basePath, boolean readOnly, TypeMirror idType) {
        String componentName = "Sprout" + simpleName;
        ClassName repository = ClassName.get((String)(basePath + ".repositories"), (String)(componentName + "Repository"), (String[])new String[0]);
        ClassName operations = ClassName.get((String)(basePath + ".services"), (String)(componentName + "Operations"), (String[])new String[0]);
        ClassName entityType = ClassName.get((TypeElement)type);
        TypeName idT = TypeName.get((TypeMirror)idType);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(componentName + "Service")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(SERVICE).addSuperinterface((TypeName)operations).addField(FieldSpec.builder((TypeName)repository, (String)"repository", (Modifier[])new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)repository, "repository", new Modifier[0]).addStatement("this.repository = repository", new Object[0]).build()).addMethod(SproutServiceGenerator.generateFindAllMethod(entityType)).addMethod(SproutServiceGenerator.generateFindByIdMethod(entityType, idT));
        if (!readOnly) {
            builder.addMethod(SproutServiceGenerator.generateSaveMethod(entityType)).addMethod(SproutServiceGenerator.generateUpdateMethod(entityType, idT)).addMethod(SproutServiceGenerator.generateDeleteMethod(idT));
        }
        if (readOnly) {
            builder.addAnnotation(AnnotationSpec.builder((ClassName)TRANSACTIONAL).addMember("readOnly", "$L", new Object[]{true}).build());
        }
        return builder;
    }

    private static MethodSpec generateFindAllMethod(ClassName entityType) {
        return MethodSpec.methodBuilder((String)"findAll").addAnnotation(OVERRIDE).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)LIST, (TypeName[])new TypeName[]{entityType})).addStatement("return repository.findAll()", new Object[0]).build();
    }

    private static MethodSpec generateFindByIdMethod(ClassName entityType, TypeName idT) {
        return MethodSpec.methodBuilder((String)"findById").addAnnotation(OVERRIDE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(idT, "id", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)OPTIONAL, (TypeName[])new TypeName[]{entityType})).addStatement("return repository.findById(id)", new Object[0]).build();
    }

    private static MethodSpec generateSaveMethod(ClassName entityType) {
        return MethodSpec.methodBuilder((String)"save").addAnnotation(TRANSACTIONAL).addAnnotation(OVERRIDE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)entityType, "entity", new Modifier[0]).returns((TypeName)entityType).addStatement("return repository.save(entity)", new Object[0]).build();
    }

    private static MethodSpec generateUpdateMethod(ClassName entityType, TypeName idT) {
        return MethodSpec.methodBuilder((String)"update").addAnnotation(TRANSACTIONAL).addAnnotation(OVERRIDE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(idT, "id", new Modifier[0]).addParameter((TypeName)entityType, "entity", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)OPTIONAL, (TypeName[])new TypeName[]{entityType})).addStatement("return repository.findById(id).map(existing -> { $T.copyProperties(entity, existing, $S); return repository.save(existing); })", new Object[]{BEAN_UTILS, "id"}).build();
    }

    private static MethodSpec generateDeleteMethod(TypeName idT) {
        return MethodSpec.methodBuilder((String)"deleteById").addAnnotation(TRANSACTIONAL).addAnnotation(OVERRIDE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(idT, "id", new Modifier[0]).returns(TypeName.BOOLEAN).beginControlFlow("if (!repository.existsById(id))", new Object[0]).addStatement("return false", new Object[0]).endControlFlow().addStatement("repository.deleteById(id)", new Object[0]).addStatement("return true", new Object[0]).build();
    }
}

