/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.sprout.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class SproutRepositoryGenerator {
    private static final String SPRING_DATA = "org.springframework.data.";
    private static final String SPRING_DATA_JPA = "org.springframework.data.jpa.repository";
    private static final ClassName QUERY_CLASS = ClassName.get((String)"org.springframework.data.jpa.repository", (String)"Query", (String[])new String[0]);
    private static final ClassName PARAMETER_CLASS = ClassName.get((String)"org.springframework.data.repository.query", (String)"Param", (String[])new String[0]);
    private static final ClassName MODIFYING_CLASS = ClassName.get((String)"org.springframework.data.jpa.repository", (String)"Modifying", (String[])new String[0]);
    private static final ClassName TRANSACTIONAL_CLASS = ClassName.get((String)"org.springframework.transaction.annotation", (String)"Transactional", (String[])new String[0]);

    private SproutRepositoryGenerator() {
    }

    public static TypeSpec.Builder generateRepository(TypeElement type, String simpleName, String entityName, String idName, boolean overrideRepository, TypeMirror idType) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)("Sprout" + simpleName + "Repository")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)SPRING_DATA_JPA, (String)"JpaRepository", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((TypeElement)type), TypeName.get((TypeMirror)idType)})).addMethod(SproutRepositoryGenerator.generateDeleteByIdMethod(entityName, idName, TypeName.get((TypeMirror)idType)));
        if (overrideRepository) {
            builder.addAnnotation(ClassName.get((String)"org.springframework.data.repository", (String)"NoRepositoryBean", (String[])new String[0]));
        } else {
            builder.addAnnotation(ClassName.get((String)"org.springframework.stereotype", (String)"Repository", (String[])new String[0]));
        }
        return builder;
    }

    private static MethodSpec generateDeleteByIdMethod(String entityName, String idName, TypeName idType) {
        return MethodSpec.methodBuilder((String)"deleteById").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder((ClassName)MODIFYING_CLASS).addMember("clearAutomatically", "$L", new Object[]{true}).addMember("flushAutomatically", "$L", new Object[]{true}).build()).addAnnotation(TRANSACTIONAL_CLASS).addAnnotation(AnnotationSpec.builder((ClassName)QUERY_CLASS).addMember("value", "$S", new Object[]{"delete from " + entityName + " e where e." + idName + " = :id"}).build()).addParameter(ParameterSpec.builder((TypeName)idType, (String)"id", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)PARAMETER_CLASS).addMember("value", "$S", new Object[]{"id"}).build()).build()).returns(TypeName.VOID).build();
    }
}

