/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.sprout.processor;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import de.flix29.sprout.annotations.SproutPolicy;
import de.flix29.sprout.annotations.SproutResource;
import de.flix29.sprout.processor.SproutControllerProcessor;
import de.flix29.sprout.processor.SproutMarkerProcessor;
import de.flix29.sprout.processor.SproutOperationsGenerator;
import de.flix29.sprout.processor.SproutRepositoryGenerator;
import de.flix29.sprout.processor.SproutServiceGenerator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
@AutoService(value={Processor.class})
public class SproutProcessor
extends AbstractProcessor {
    private static final String SPROUT_ID = "de.flix29.sprout.annotations.SproutId";
    private static final String JAKARTA_ID = "jakarta.persistence.Id";
    private static final String JAVAX_ID = "javax.persistence.Id";
    private static final String JAKARTA_EMBEDDED_ID = "jakarta.persistence.EmbeddedId";
    private static final String JAVAX_EMBEDDED_ID = "javax.persistence.EmbeddedId";
    private static final List<String> ID_ORDER = List.of("de.flix29.sprout.annotations.SproutId", "jakarta.persistence.Id", "javax.persistence.Id");
    private static final String JAKARTA_ENTITY = "jakarta.persistence.Entity";
    private static final String JAVAX_ENTITY = "javax.persistence.Entity";
    private static final String PRE_AUTHORIZE = "org.springframework.security.access.prepost.PreAuthorize";
    private static final String SWAGGER_API_RESPONSE = "io.swagger.v3.oas.annotations.responses.ApiResponses";
    private static final String SWAGGER_TAG = "io.swagger.v3.oas.annotations.tags.Tag";

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(SproutResource.class.getCanonicalName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        List<TypeElement> classes = roundEnv.getElementsAnnotatedWith(SproutResource.class).stream().filter(element -> element.getKind().isClass()).filter(TypeElement.class::isInstance).map(TypeElement.class::cast).toList();
        for (TypeElement type : classes) {
            Element idElement;
            SproutResource annotation = type.getAnnotation(SproutResource.class);
            SproutPolicy policyAnnotation = type.getAnnotation(SproutPolicy.class);
            String simpleName = annotation.name().isBlank() ? type.getSimpleName().toString() : annotation.name();
            String entityName = this.resolveJpaEntityName(type);
            if (entityName == null || entityName.isBlank()) {
                entityName = simpleName;
            }
            String derivedPath = "/api/" + simpleName.toLowerCase() + "s";
            String apiPath = annotation.path() != null && !annotation.path().isBlank() ? annotation.path() : derivedPath;
            boolean policyNeeded = this.checkIfPolicyNeeded(policyAnnotation);
            boolean swaggerNeeded = this.checkIfSwaggerNeeded(annotation);
            String basePackage = this.baseGeneratedPackage(type);
            String className = simpleName + "SproutMarker";
            try {
                idElement = this.findIdElement(type);
            }
            catch (IllegalStateException ex) {
                continue;
            }
            TypeMirror idType = this.getIdTypeFromElement(idElement);
            String idName = this.getIdNameFromElement(idElement);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("[Sprout] ID for %s -> '%s' with type %s", type.getSimpleName(), idName, idType));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[Sprout] Generating marker for " + simpleName + " at apiPath " + apiPath);
            TypeSpec.Builder marker = SproutMarkerProcessor.generateMarker(idType, className, apiPath, policyAnnotation, entityName, idName);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[Sprout] Generating repository for " + simpleName);
            TypeSpec.Builder repository = SproutRepositoryGenerator.generateRepository(type, simpleName, entityName, idName, annotation.overrideRepository(), idType);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("[Sprout] Generating%s operations for %s ", annotation.readOnly() ? " readonly" : "", simpleName));
            TypeSpec.Builder operations = SproutOperationsGenerator.generateOperations(type, simpleName, annotation.readOnly(), idType);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("[Sprout] Generating%s service for %s ", annotation.readOnly() ? " readonly" : "", simpleName));
            TypeSpec.Builder service = SproutServiceGenerator.generateService(type, simpleName, basePackage, annotation.readOnly(), idType);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[Sprout] Generating controller for " + simpleName);
            TypeSpec.Builder controller = SproutControllerProcessor.generateController(type, simpleName, basePackage, annotation, swaggerNeeded, (SproutPolicy)(policyNeeded ? policyAnnotation : null), apiPath, idType);
            JavaFile markerFile = this.createJavaFile(basePackage + ".marker", marker);
            JavaFile repositoryFile = this.createJavaFile(basePackage + ".repositories", repository);
            JavaFile operationsFile = this.createJavaFile(basePackage + ".services", operations);
            JavaFile serviceFile = this.createJavaFile(basePackage + ".services", service);
            JavaFile controllerFile = this.createJavaFile(basePackage + ".controllers", controller);
            this.writeFiles(markerFile, repositoryFile, operationsFile, serviceFile, controllerFile);
        }
        return true;
    }

    private String baseGeneratedPackage(TypeElement type) {
        String entityPkg = this.processingEnv.getElementUtils().getPackageOf(type).getQualifiedName().toString();
        return entityPkg + ".generated";
    }

    private Element findIdElement(TypeElement type) throws IllegalStateException {
        if (this.hasEmbeddedId(type)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "[Sprout] @EmbeddedId is not supported " + String.valueOf(type.getQualifiedName()));
            throw new IllegalStateException("EmbeddedId is not supported in Sprout. Please use a single field or method annotated with @SproutId, @jakarta.persistence.Id, or @javax.persistence.Id.");
        }
        for (String id : ID_ORDER) {
            List<Element> idElements = this.getAllFieldsOrMethodsAnnotatedBy(type, id);
            if (idElements.size() > 1) {
                String idNames = idElements.stream().map(this::prettyPrintElement).collect(Collectors.joining(", "));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "[Sprout] Multiple ID fields or methods found in " + String.valueOf(type.getQualifiedName()) + ": " + idNames + ". ");
                throw new IllegalStateException("Multiple ID fields or methods found in " + String.valueOf(type.getQualifiedName()));
            }
            if (idElements.size() != 1) continue;
            return idElements.getFirst();
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "[Sprout] No ID field or method found in " + String.valueOf(type.getQualifiedName()) + ". Please annotate one field or method with @SproutId, @jakarta.persistence.Id, or @javax.persistence.Id.");
        throw new IllegalStateException("No ID field or method found in " + String.valueOf(type.getQualifiedName()) + ". Please annotate one field or method with @SproutId, @jakarta.persistence.Id, or @javax.persistence.Id.");
    }

    private TypeMirror getIdTypeFromElement(Element idElement) {
        TypeMirror typeMirror = idElement.getKind() == ElementKind.METHOD ? ((ExecutableElement)idElement).getReturnType() : idElement.asType();
        return this.canonicalBoxedErasure(typeMirror);
    }

    private String getIdNameFromElement(Element element) {
        String name = element.getSimpleName().toString();
        return switch (element.getKind()) {
            case ElementKind.FIELD -> name;
            case ElementKind.METHOD -> {
                if (name.startsWith("get") && name.length() > 3) {
                    name = name.substring(3);
                } else if (name.startsWith("is") && name.length() > 2) {
                    name = name.substring(2);
                }
                yield Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            default -> name;
        };
    }

    private boolean hasEmbeddedId(TypeElement type) {
        return !this.getAllAnnotatedBy(type, JAKARTA_EMBEDDED_ID).isEmpty() || !this.getAllAnnotatedBy(type, JAVAX_EMBEDDED_ID).isEmpty();
    }

    private List<Element> getAllFieldsOrMethodsAnnotatedBy(TypeElement type, String annotationName) {
        return this.getAllAnnotatedBy(type, annotationName).stream().filter(this::isNonStaticFieldOrMethod).toList();
    }

    private List<Element> getAllAnnotatedBy(TypeElement type, String annotationName) {
        return this.processingEnv.getElementUtils().getAllMembers(type).stream().filter(Objects::nonNull).map(Element.class::cast).filter(element -> element.getAnnotationMirrors().stream().anyMatch(annotationMirror -> annotationMirror.getAnnotationType().toString().equals(annotationName))).toList();
    }

    private String resolveJpaEntityName(TypeElement type) {
        AnnotationMirror annotationMirror = this.findAnnotation(type, JAKARTA_ENTITY);
        if (annotationMirror == null) {
            annotationMirror = this.findAnnotation(type, JAVAX_ENTITY);
        }
        if (annotationMirror == null) {
            return type.getSimpleName().toString();
        }
        return this.getAnnotationStringValue(annotationMirror, "name").filter(s -> !s.isBlank()).orElse(type.getSimpleName().toString());
    }

    private AnnotationMirror findAnnotation(Element element, String annotationName) {
        return element.getAnnotationMirrors().stream().filter(annotationMirror -> annotationMirror.getAnnotationType().toString().equals(annotationName)).findFirst().orElse(null);
    }

    private Optional<String> getAnnotationStringValue(AnnotationMirror annotationMirror, String attributeName) {
        return annotationMirror.getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().contentEquals(attributeName)).map(Map.Entry::getValue).map(AnnotationValue::getValue).filter(String.class::isInstance).map(String.class::cast).findFirst();
    }

    private boolean checkIfPolicyNeeded(SproutPolicy policyAnnotation) {
        if (policyAnnotation != null && !this.hasClass(PRE_AUTHORIZE)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "[Sprout] @SproutPolicy found but Spring Security is not on the classpath. Please add spring-security-core and spring-security-config to your dependencies.");
            return false;
        }
        return true;
    }

    private boolean checkIfSwaggerNeeded(SproutResource resourceAnnotation) {
        if (!(resourceAnnotation == null || !resourceAnnotation.generateSwaggerDocs() || this.hasClass(SWAGGER_API_RESPONSE) && this.hasClass(SWAGGER_TAG))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "[Sprout] Trying to generate Swagger Documentation but springdoc-openapi is not on the classpath. Please add springdoc-openapi-starter-webmvc-ui to your dependencies.");
            return false;
        }
        return true;
    }

    private boolean isNonStaticFieldOrMethod(Element element) {
        if (element.getKind().isField()) {
            return !element.getModifiers().contains((Object)Modifier.STATIC);
        }
        if (element.getKind() == ElementKind.METHOD) {
            ExecutableElement method = (ExecutableElement)element;
            return !method.getModifiers().contains((Object)Modifier.STATIC) && method.getParameters().isEmpty() && method.getReturnType().getKind() != TypeKind.VOID;
        }
        return false;
    }

    private TypeMirror canonicalBoxedErasure(TypeMirror type) {
        Types types = this.processingEnv.getTypeUtils();
        if (type.getKind().isPrimitive()) {
            return types.boxedClass((PrimitiveType)type).asType();
        }
        return types.erasure(type);
    }

    private String prettyPrintElement(Element element) {
        return switch (element.getKind()) {
            case ElementKind.FIELD -> "Field: '" + String.valueOf(element.getSimpleName()) + "'";
            case ElementKind.METHOD -> "Method: '" + String.valueOf(element.getSimpleName()) + "()'";
            default -> element.getSimpleName().toString();
        };
    }

    private JavaFile createJavaFile(String pkg, TypeSpec.Builder type) {
        this.addGeneratedAnnotation(type);
        return JavaFile.builder((String)pkg, (TypeSpec)type.build()).skipJavaLangImports(true).indent("    ").build();
    }

    private void addGeneratedAnnotation(TypeSpec.Builder typeBuilder) {
        typeBuilder.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"javax.annotation.processing", (String)"Generated", (String[])new String[0])).addMember("value", "$S", new Object[]{"SproutProcessor"}).build());
    }

    private void writeFiles(JavaFile ... files) {
        try {
            for (JavaFile javaFile : files) {
                javaFile.writeTo(this.processingEnv.getFiler());
            }
        }
        catch (IOException ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "[Sprout] Failed to write generated sources: " + ex.getMessage());
        }
    }

    private boolean hasClass(String typeName) {
        return this.processingEnv.getElementUtils().getTypeElement(typeName) != null;
    }
}

