/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.sprout.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class SproutOperationsGenerator {
    private static final ClassName LIST = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
    private static final ClassName OPTIONAL = ClassName.get((String)"java.util", (String)"Optional", (String[])new String[0]);

    private SproutOperationsGenerator() {
    }

    public static TypeSpec.Builder generateOperations(TypeElement type, String simpleName, boolean readOnly, TypeMirror idType) {
        ClassName entityType = ClassName.get((TypeElement)type);
        TypeName idT = TypeName.get((TypeMirror)idType);
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)("Sprout" + simpleName + "Operations")).addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addMethod(SproutOperationsGenerator.createFindAllMethod(entityType)).addMethod(SproutOperationsGenerator.createFindByIdMethod(entityType, idT));
        if (!readOnly) {
            builder.addMethod(SproutOperationsGenerator.createSaveMethod(entityType)).addMethod(SproutOperationsGenerator.createUpdateMethod(entityType, idT)).addMethod(SproutOperationsGenerator.createDeleteMethod(idT));
        }
        return builder;
    }

    private static MethodSpec createFindAllMethod(ClassName entityType) {
        return MethodSpec.methodBuilder((String)"findAll").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)ParameterizedTypeName.get((ClassName)LIST, (TypeName[])new TypeName[]{entityType})).build();
    }

    private static MethodSpec createFindByIdMethod(ClassName entityType, TypeName idT) {
        return MethodSpec.methodBuilder((String)"findById").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(idT, "id", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)OPTIONAL, (TypeName[])new TypeName[]{entityType})).build();
    }

    private static MethodSpec createSaveMethod(ClassName entityType) {
        return MethodSpec.methodBuilder((String)"save").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)entityType, "entity", new Modifier[0]).returns((TypeName)entityType).build();
    }

    private static MethodSpec createUpdateMethod(ClassName entityType, TypeName idT) {
        return MethodSpec.methodBuilder((String)"update").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(idT, "id", new Modifier[0]).addParameter((TypeName)entityType, "entity", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)OPTIONAL, (TypeName[])new TypeName[]{entityType})).build();
    }

    private static MethodSpec createDeleteMethod(TypeName idT) {
        return MethodSpec.methodBuilder((String)"deleteById").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(idT, "id", new Modifier[0]).returns(TypeName.BOOLEAN).build();
    }
}

