/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.sprout.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import de.flix29.sprout.annotations.SproutPolicy;
import de.flix29.sprout.annotations.SproutResource;
import de.flix29.sprout.annotations.model.Endpoint;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class SproutControllerProcessor {
    private static final String SPRING_WEB_ANNOTATION_PACKAGE = "org.springframework.web.bind.annotation";
    private static final String SWAGGER_API_RESPONSE_ANNOTATION = "io.swagger.v3.oas.annotations.responses.ApiResponse";
    private static final ClassName PATH_VARIABLE_CLASS = ClassName.get((String)"org.springframework.web.bind.annotation", (String)"PathVariable", (String[])new String[0]);
    private static final ClassName RESPONSE_ENTITY_CLASS = ClassName.get((String)"org.springframework.http", (String)"ResponseEntity", (String[])new String[0]);
    private static final ClassName LIST_CLASS = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
    private static final ClassName API_RESPONSES = ClassName.get((String)"io.swagger.v3.oas.annotations.responses", (String)"ApiResponses", (String[])new String[0]);
    private static final String SWAGGER_OK = SproutControllerProcessor.generateSwaggerApiResponseString(200, "Successful retrieval");
    private static final String SWAGGER_CREATED = SproutControllerProcessor.generateSwaggerApiResponseString(201, "Successfully created");
    private static final String SWAGGER_NO_CONTENT = SproutControllerProcessor.generateSwaggerApiResponseString(204, "Successfully deleted");
    private static final String SWAGGER_BAD_REQUEST = SproutControllerProcessor.generateSwaggerApiResponseString(400, "Invalid input data");
    private static final String SWAGGER_UNAUTHORIZED = SproutControllerProcessor.generateSwaggerApiResponseString(401, "Unauthorized");
    private static final String SWAGGER_ACCESS_DENIED = SproutControllerProcessor.generateSwaggerApiResponseString(403, "Access denied");
    private static final String SWAGGER_NOT_FOUND = SproutControllerProcessor.generateSwaggerApiResponseString(404, "Not found");
    private static final String SWAGGER_INTERNAL_SERVER_ERROR = SproutControllerProcessor.generateSwaggerApiResponseString(500, "Internal server error");
    private static final String APPLICATION_JSON = "application/json";
    private static final String ID = "/{id}";
    private static final String VALUE = "value";

    private SproutControllerProcessor() {
    }

    protected static TypeSpec.Builder generateController(TypeElement type, String simpleName, String basePackage, SproutResource sproutResource, boolean swaggerNeeded, SproutPolicy policy, String apiPath, TypeMirror idType) {
        String componentName = "Sprout" + simpleName;
        ClassName operations = ClassName.get((String)(basePackage + ".services"), (String)(componentName + "Operations"), (String[])new String[0]);
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)(componentName + "Controller")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(ClassName.get((String)SPRING_WEB_ANNOTATION_PACKAGE, (String)"RestController", (String[])new String[0])).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)SPRING_WEB_ANNOTATION_PACKAGE, (String)"RequestMapping", (String[])new String[0])).addMember("path", "$S", new Object[]{apiPath}).addMember("produces", "$S", new Object[]{APPLICATION_JSON}).build()).addField(FieldSpec.builder((TypeName)operations, (String)"operations", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)operations, "operations", new Modifier[0]).addStatement("this.operations = operations", new Object[0]).build());
        if (sproutResource.generateSwaggerDocs() && swaggerNeeded) {
            typeSpec.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"io.swagger.v3.oas.annotations.tags", (String)"Tag", (String[])new String[0])).addMember("name", "$S", new Object[]{SproutControllerProcessor.getTagName(sproutResource, simpleName)}).addMember("description", "$S", new Object[]{sproutResource.summary()}).build());
        }
        if (SproutControllerProcessor.methodGenerationAllowed(Endpoint.GET_ALL, sproutResource)) {
            typeSpec.addMethod(SproutControllerProcessor.generateGetAllMethod(type, simpleName, policy == null ? null : policy.read(), sproutResource.generateSwaggerDocs() && swaggerNeeded));
        }
        if (SproutControllerProcessor.methodGenerationAllowed(Endpoint.GET_BY_ID, sproutResource)) {
            typeSpec.addMethod(SproutControllerProcessor.generateGetByIdMethod(type, simpleName, idType, policy == null ? null : policy.read(), sproutResource.generateSwaggerDocs() && swaggerNeeded));
        }
        if (!sproutResource.readOnly()) {
            if (SproutControllerProcessor.methodGenerationAllowed(Endpoint.CREATE, sproutResource)) {
                typeSpec.addMethod(SproutControllerProcessor.generatePostMethod(type, simpleName, policy == null ? null : policy.create(), sproutResource.generateSwaggerDocs() && swaggerNeeded));
            }
            if (SproutControllerProcessor.methodGenerationAllowed(Endpoint.UPDATE, sproutResource)) {
                typeSpec.addMethod(SproutControllerProcessor.generatePutMethod(type, simpleName, idType, policy == null ? null : policy.update(), sproutResource.generateSwaggerDocs() && swaggerNeeded));
            }
            if (SproutControllerProcessor.methodGenerationAllowed(Endpoint.DELETE, sproutResource)) {
                typeSpec.addMethod(SproutControllerProcessor.generateDeleteMethod(simpleName, idType, policy == null ? null : policy.delete(), sproutResource.generateSwaggerDocs() && swaggerNeeded));
            }
        }
        return typeSpec;
    }

    private static MethodSpec generateGetAllMethod(TypeElement type, String simpleName, String policy, boolean generateSwaggerDocs) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"getAll").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)SPRING_WEB_ANNOTATION_PACKAGE, (String)"GetMapping", (String[])new String[0])).build()).returns((TypeName)ParameterizedTypeName.get((ClassName)RESPONSE_ENTITY_CLASS, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)LIST_CLASS, (TypeName[])new TypeName[]{ClassName.get((TypeElement)type)})})).addJavadoc("Returns all $L items.\n", new Object[]{simpleName}).addStatement("return $T.ok(operations.findAll())", new Object[]{RESPONSE_ENTITY_CLASS});
        if (generateSwaggerDocs) {
            SproutControllerProcessor.addSwaggerApiResponsesAnnotation(methodSpec, SWAGGER_OK, SWAGGER_UNAUTHORIZED, SWAGGER_ACCESS_DENIED, SWAGGER_INTERNAL_SERVER_ERROR);
        }
        if (policy != null && !policy.isBlank()) {
            methodSpec.addAnnotation(SproutControllerProcessor.generatePreAuthorizeAnnotation(policy));
        }
        return methodSpec.build();
    }

    private static MethodSpec generateGetByIdMethod(TypeElement type, String simpleName, TypeMirror idType, String policy, boolean generateSwaggerDocs) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"getById").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)SPRING_WEB_ANNOTATION_PACKAGE, (String)"GetMapping", (String[])new String[0])).addMember("path", "$S", new Object[]{ID}).build()).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)idType), (String)"id", (Modifier[])new Modifier[0]).addAnnotation(PATH_VARIABLE_CLASS).build()).returns((TypeName)ParameterizedTypeName.get((ClassName)RESPONSE_ENTITY_CLASS, (TypeName[])new TypeName[]{ClassName.get((TypeElement)type)})).addJavadoc("Returns a single $L item by its ID.\n", new Object[]{simpleName}).addStatement("return operations.findById(id)\n        .map($T::ok)\n        .orElse($T.notFound().build())\n", new Object[]{RESPONSE_ENTITY_CLASS, RESPONSE_ENTITY_CLASS});
        if (generateSwaggerDocs) {
            SproutControllerProcessor.addSwaggerApiResponsesAnnotation(methodSpec, SWAGGER_OK, SWAGGER_UNAUTHORIZED, SWAGGER_ACCESS_DENIED, SWAGGER_NOT_FOUND, SWAGGER_INTERNAL_SERVER_ERROR);
        }
        if (policy != null && !policy.isBlank()) {
            methodSpec.addAnnotation(SproutControllerProcessor.generatePreAuthorizeAnnotation(policy));
        }
        return methodSpec.build();
    }

    private static MethodSpec generatePostMethod(TypeElement type, String simpleName, String policy, boolean generateSwaggerDocs) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)SPRING_WEB_ANNOTATION_PACKAGE, (String)"PostMapping", (String[])new String[0])).addMember("consumes", "$S", new Object[]{APPLICATION_JSON}).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)type), (String)("new" + simpleName), (Modifier[])new Modifier[0]).addAnnotation(ClassName.get((String)SPRING_WEB_ANNOTATION_PACKAGE, (String)"RequestBody", (String[])new String[0])).addAnnotation(ClassName.get((String)"jakarta.validation", (String)"Valid", (String[])new String[0])).build()).returns((TypeName)ParameterizedTypeName.get((ClassName)RESPONSE_ENTITY_CLASS, (TypeName[])new TypeName[]{ClassName.get((TypeElement)type)})).addJavadoc("Creates a new $L item.\n", new Object[]{simpleName}).addStatement("return $T.status($T.CREATED).body(operations.save(new$L))", new Object[]{RESPONSE_ENTITY_CLASS, ClassName.get((String)"org.springframework.http", (String)"HttpStatus", (String[])new String[0]), simpleName});
        if (generateSwaggerDocs) {
            SproutControllerProcessor.addSwaggerApiResponsesAnnotation(methodSpec, SWAGGER_CREATED, SWAGGER_BAD_REQUEST, SWAGGER_UNAUTHORIZED, SWAGGER_ACCESS_DENIED, SWAGGER_INTERNAL_SERVER_ERROR);
        }
        if (policy != null && !policy.isBlank()) {
            methodSpec.addAnnotation(SproutControllerProcessor.generatePreAuthorizeAnnotation(policy));
        }
        return methodSpec.build();
    }

    private static MethodSpec generatePutMethod(TypeElement type, String simpleName, TypeMirror idType, String policy, boolean generateSwaggerDocs) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"update").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)SPRING_WEB_ANNOTATION_PACKAGE, (String)"PutMapping", (String[])new String[0])).addMember("path", "$S", new Object[]{ID}).addMember("consumes", "$S", new Object[]{APPLICATION_JSON}).build()).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)idType), (String)"id", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)PATH_VARIABLE_CLASS).addMember(VALUE, "$S", new Object[]{"id"}).build()).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)type), (String)("updated" + simpleName), (Modifier[])new Modifier[0]).addAnnotation(ClassName.get((String)SPRING_WEB_ANNOTATION_PACKAGE, (String)"RequestBody", (String[])new String[0])).addAnnotation(ClassName.get((String)"jakarta.validation", (String)"Valid", (String[])new String[0])).build()).returns((TypeName)ParameterizedTypeName.get((ClassName)RESPONSE_ENTITY_CLASS, (TypeName[])new TypeName[]{ClassName.get((TypeElement)type)})).addJavadoc("Updates an existing $L item by its ID.\n", new Object[]{simpleName}).addStatement("return operations.update(id, updated$L)\n    .map($T::ok)\n    .orElse($T.notFound().build())\n", new Object[]{simpleName, RESPONSE_ENTITY_CLASS, RESPONSE_ENTITY_CLASS});
        if (generateSwaggerDocs) {
            SproutControllerProcessor.addSwaggerApiResponsesAnnotation(methodSpec, SWAGGER_OK, SWAGGER_BAD_REQUEST, SWAGGER_UNAUTHORIZED, SWAGGER_ACCESS_DENIED, SWAGGER_NOT_FOUND, SWAGGER_INTERNAL_SERVER_ERROR);
        }
        if (policy != null && !policy.isBlank()) {
            methodSpec.addAnnotation(SproutControllerProcessor.generatePreAuthorizeAnnotation(policy));
        }
        return methodSpec.build();
    }

    private static MethodSpec generateDeleteMethod(String simpleName, TypeMirror idType, String policy, boolean generateSwaggerDocs) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"deleteById").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)SPRING_WEB_ANNOTATION_PACKAGE, (String)"DeleteMapping", (String[])new String[0])).addMember("path", "$S", new Object[]{ID}).build()).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)idType), (String)"id", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)PATH_VARIABLE_CLASS).addMember(VALUE, "$S", new Object[]{"id"}).build()).build()).returns((TypeName)ParameterizedTypeName.get((ClassName)RESPONSE_ENTITY_CLASS, (TypeName[])new TypeName[]{TypeName.VOID.box()})).addJavadoc("Deletes an existing $L item by its ID.\n", new Object[]{simpleName}).addStatement("return operations.deleteById(id) ? $T.noContent().build() : $T.notFound().build()", new Object[]{RESPONSE_ENTITY_CLASS, RESPONSE_ENTITY_CLASS});
        if (generateSwaggerDocs) {
            SproutControllerProcessor.addSwaggerApiResponsesAnnotation(methodSpec, SWAGGER_NO_CONTENT, SWAGGER_UNAUTHORIZED, SWAGGER_ACCESS_DENIED, SWAGGER_NOT_FOUND, SWAGGER_INTERNAL_SERVER_ERROR);
        }
        if (policy != null && !policy.isBlank()) {
            methodSpec.addAnnotation(SproutControllerProcessor.generatePreAuthorizeAnnotation(policy));
        }
        return methodSpec.build();
    }

    private static boolean methodGenerationAllowed(Endpoint endpoint, SproutResource sproutResource) {
        List<Endpoint> excluded = Arrays.asList(sproutResource.exclude());
        if (excluded.contains(endpoint)) {
            return false;
        }
        if (sproutResource.include().length == 0) {
            return true;
        }
        if (sproutResource.readOnly() && (endpoint == Endpoint.GET_ALL || endpoint == Endpoint.GET_BY_ID)) {
            return true;
        }
        return Arrays.asList(sproutResource.include()).contains(endpoint);
    }

    private static AnnotationSpec generatePreAuthorizeAnnotation(String policy) {
        return AnnotationSpec.builder((ClassName)ClassName.get((String)"org.springframework.security.access.prepost", (String)"PreAuthorize", (String[])new String[0])).addMember(VALUE, "$S", new Object[]{policy}).build();
    }

    private static String getTagName(SproutResource sproutResource, String simpleName) {
        if (!sproutResource.tag().isBlank()) {
            return sproutResource.tag();
        }
        if (!sproutResource.name().isBlank()) {
            return sproutResource.name();
        }
        return simpleName;
    }

    private static String generateSwaggerApiResponseString(int responseCode, String description) {
        return "@%s(responseCode = \"%d\", description = \"%s\")".formatted(SWAGGER_API_RESPONSE_ANNOTATION, responseCode, description);
    }

    private static void addSwaggerApiResponsesAnnotation(MethodSpec.Builder methodSpec, String ... apiResponses) {
        AnnotationSpec.Builder annotationSpec = AnnotationSpec.builder((ClassName)API_RESPONSES);
        Arrays.stream(apiResponses).forEach(apiResponse -> annotationSpec.addMember(VALUE, "$L", new Object[]{apiResponse}));
        methodSpec.addAnnotation(annotationSpec.build());
    }
}

