/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient.customDeserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.flix29.notionApiClient.customDeserializer.CustomDeserializerUtils;
import de.flix29.notionApiClient.model.Bot;
import de.flix29.notionApiClient.model.BotOwner;
import de.flix29.notionApiClient.model.BotOwnerType;
import de.flix29.notionApiClient.model.People;
import de.flix29.notionApiClient.model.User;
import de.flix29.notionApiClient.model.UserType;
import java.lang.reflect.Type;

public class CustomUserDeserializer
implements JsonDeserializer<User> {
    public User deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject == null || jsonObject.isJsonNull() || jsonObject.isJsonPrimitive()) {
            return null;
        }
        UserType userType = UserType.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "type"));
        User user = new User().id(CustomDeserializerUtils.getUUIDFromJsonElement((JsonElement)jsonObject, "id")).type(userType).name(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "name")).avatarUrl(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "avatar_url"));
        return switch (userType) {
            default -> throw new MatchException(null, null);
            case UserType.PERSON -> this.buildPerson(user, jsonObject);
            case UserType.BOT -> this.buildBot(user, jsonObject);
            case UserType.INTEGRATION, UserType.UNKNOWN -> user;
        };
    }

    private People buildPerson(User user, JsonObject jsonObject) {
        return new People(user).email(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject.getAsJsonObject("person"), "email"));
    }

    private Bot buildBot(User user, JsonObject jsonObject) {
        if (jsonObject.getAsJsonObject("bot").isJsonNull() || jsonObject.getAsJsonObject("bot").isEmpty()) {
            return new Bot(user);
        }
        JsonObject bot = jsonObject.getAsJsonObject("bot");
        JsonObject owner = bot.getAsJsonObject("owner");
        return new Bot(user).owner(new BotOwner().type(BotOwnerType.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(owner, "type"))).workspaces(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(owner, "workspace"))).workspaceName(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(bot, "workspace_name"));
    }
}

