/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient.customDeserializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.flix29.notionApiClient.customDeserializer.CustomAnnotationsDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomDeserializerUtils;
import de.flix29.notionApiClient.model.Annotations;
import de.flix29.notionApiClient.model.Equation;
import de.flix29.notionApiClient.model.MentionDatabase;
import de.flix29.notionApiClient.model.MentionDate;
import de.flix29.notionApiClient.model.MentionLinkPreview;
import de.flix29.notionApiClient.model.MentionPage;
import de.flix29.notionApiClient.model.MentionTemplate;
import de.flix29.notionApiClient.model.MentionType;
import de.flix29.notionApiClient.model.MentionUser;
import de.flix29.notionApiClient.model.RichText;
import de.flix29.notionApiClient.model.Text;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;

public class CustomRichTextDeserializer
implements JsonDeserializer<List<RichText>> {
    public List<RichText> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        return jsonArray.asList().stream().filter(item -> item != null && !item.isJsonNull()).map(item -> {
            JsonObject jsonObject = item.getAsJsonObject();
            String textType = CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "type");
            RichText richText = new RichText().plainText(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "plain_text")).href(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "href")).annotations(new CustomAnnotationsDeserializer().deserialize(jsonObject.get("annotations"), (Type)((Object)Annotations.class), jsonDeserializationContext));
            if (textType == null) {
                throw new JsonParseException("No text type found in rich text object");
            }
            return switch (textType) {
                case "text" -> {
                    JsonObject text = item.getAsJsonObject().get("text").getAsJsonObject();
                    yield new Text(richText).content(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(text, "content")).link(text.get("link").isJsonNull() ? null : CustomDeserializerUtils.getAsStringIfPresentAndNotNull(text.getAsJsonObject("link"), "url"));
                }
                case "mention" -> {
                    MentionType mentionType = MentionType.fromString(jsonObject.getAsJsonObject("mention").get("type").getAsString());
                    JsonObject mention = jsonObject.getAsJsonObject("mention").getAsJsonObject(mentionType.getType());
                    switch (mentionType) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case DATABASE: {
                            yield new MentionDatabase(richText).id(mention.get("id").getAsString());
                        }
                        case DATE: {
                            yield new MentionDate(richText).start(OffsetDateTime.parse(mention.get("start").getAsString())).end(OffsetDateTime.parse(mention.get("end").getAsString())).timeZone(mention.get("time_zone").getAsString());
                        }
                        case LINK_PREVIEW: {
                            yield new MentionLinkPreview(richText).href(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(mention, "href")).title(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(mention, "title")).iconUrl(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(mention, "icon_url")).description(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(mention, "description")).linkProvider(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(mention, "link_provider")).thumbnailUrl(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(mention, "thumbnail_url"));
                        }
                        case PAGE: {
                            yield new MentionPage(richText).id(mention.get("id").getAsString());
                        }
                        case TEMPLATE_MENTION: {
                            yield new MentionTemplate(richText).date(mention.get("date").getAsString()).user(mention.get("user").getAsString());
                        }
                        case USER: 
                    }
                    yield new MentionUser(richText).id(mention.get("id").getAsString());
                }
                case "equation" -> new Equation(richText).equation(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "equation"));
                default -> throw new IllegalStateException("Unexpected texttype value: " + textType);
            };
        }).toList();
    }
}

