/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient.customDeserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.flix29.notionApiClient.customDeserializer.CustomDeserializerUtils;
import de.flix29.notionApiClient.model.Parent;
import de.flix29.notionApiClient.model.ParentType;
import java.lang.reflect.Type;

public class CustomParentDeserializer
implements JsonDeserializer<Parent> {
    public Parent deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        ParentType parentType = ParentType.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "type"));
        Parent parent = new Parent().type(parentType);
        return switch (parentType) {
            default -> throw new MatchException(null, null);
            case ParentType.DATABASE -> parent.id(CustomDeserializerUtils.getUUIDFromJsonElement((JsonElement)jsonObject, "database_id"));
            case ParentType.PAGE -> parent.id(CustomDeserializerUtils.getUUIDFromJsonElement((JsonElement)jsonObject, "page_id"));
            case ParentType.WORKSPACE -> parent.workspace(true);
            case ParentType.BLOCK -> parent.id(CustomDeserializerUtils.getUUIDFromJsonElement((JsonElement)jsonObject, "block_id"));
        };
    }
}

