/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient.customDeserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.flix29.notionApiClient.customDeserializer.CustomDeserializerUtils;
import de.flix29.notionApiClient.customDeserializer.CustomFileDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomOffsetDateTimeDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomRichTextDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomUserDeserializer;
import de.flix29.notionApiClient.model.Color;
import de.flix29.notionApiClient.model.User;
import de.flix29.notionApiClient.model.database.databaseProperty.Button;
import de.flix29.notionApiClient.model.database.databaseProperty.Checkbox;
import de.flix29.notionApiClient.model.database.databaseProperty.CreatedBy;
import de.flix29.notionApiClient.model.database.databaseProperty.CreatedTime;
import de.flix29.notionApiClient.model.database.databaseProperty.Date;
import de.flix29.notionApiClient.model.database.databaseProperty.Email;
import de.flix29.notionApiClient.model.database.databaseProperty.File;
import de.flix29.notionApiClient.model.database.databaseProperty.Formula;
import de.flix29.notionApiClient.model.database.databaseProperty.LastEditedBy;
import de.flix29.notionApiClient.model.database.databaseProperty.LastEditedTime;
import de.flix29.notionApiClient.model.database.databaseProperty.MultiSelect;
import de.flix29.notionApiClient.model.database.databaseProperty.Number;
import de.flix29.notionApiClient.model.database.databaseProperty.People;
import de.flix29.notionApiClient.model.database.databaseProperty.PhoneNumber;
import de.flix29.notionApiClient.model.database.databaseProperty.Property;
import de.flix29.notionApiClient.model.database.databaseProperty.PropertyType;
import de.flix29.notionApiClient.model.database.databaseProperty.Relation;
import de.flix29.notionApiClient.model.database.databaseProperty.RichText;
import de.flix29.notionApiClient.model.database.databaseProperty.Rollup;
import de.flix29.notionApiClient.model.database.databaseProperty.Select;
import de.flix29.notionApiClient.model.database.databaseProperty.SelectItem;
import de.flix29.notionApiClient.model.database.databaseProperty.Status;
import de.flix29.notionApiClient.model.database.databaseProperty.StatusItem;
import de.flix29.notionApiClient.model.database.databaseProperty.Title;
import de.flix29.notionApiClient.model.database.databaseProperty.Url;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CustomPagePropertiesDeserializer
implements JsonDeserializer<List<Property>> {
    public List<Property> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        return entries.stream().filter(Objects::nonNull).map(entry -> {
            Property property;
            if (entry.getValue() == null || entry.getKey() == null || ((JsonElement)entry.getValue()).isJsonNull()) {
                return null;
            }
            JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            PropertyType propertyType = PropertyType.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "type"));
            String id = CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "id");
            String name = (String)entry.getKey();
            block0 : switch (propertyType) {
                default: {
                    throw new MatchException(null, null);
                }
                case BUTTON: {
                    Property property2 = new Button();
                    break;
                }
                case CHECKBOX: {
                    Property property2 = new Checkbox().checked(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonObject, "checkbox"));
                    break;
                }
                case CREATED_BY: {
                    Property property2 = new CreatedBy().user(new CustomUserDeserializer().deserialize(jsonObject.get("created_by"), (Type)((Object)User.class), jsonDeserializationContext));
                    break;
                }
                case CREATED_TIME: {
                    Property property2 = new CreatedTime().createdTime(new CustomOffsetDateTimeDeserializer().deserialize(jsonObject.get("created_time"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext));
                    break;
                }
                case DATE: {
                    Property property2 = new Date().start(new CustomOffsetDateTimeDeserializer().deserialize(jsonObject.getAsJsonObject("date").get("start"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext)).end(new CustomOffsetDateTimeDeserializer().deserialize(jsonObject.getAsJsonObject("date").get("end"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext)).timezone(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject.getAsJsonObject("date"), "timezone"));
                    break;
                }
                case EMAIL: {
                    Property property2 = new Email().email(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "email"));
                    break;
                }
                case FILE: {
                    Property property2 = new File().files(jsonObject.getAsJsonArray("files").asList().stream().filter(Objects::nonNull).map(file -> new CustomFileDeserializer().deserialize((JsonElement)file, (Type)((Object)File.class), jsonDeserializationContext)).toList());
                    break;
                }
                case FORMULA: {
                    Property property2;
                    JsonObject formulaObject = jsonObject.getAsJsonObject("formula");
                    String valueType = CustomDeserializerUtils.getAsStringIfPresentAndNotNull(formulaObject, "type");
                    if (valueType == null) {
                        property2 = null;
                        break;
                    }
                    switch (valueType) {
                        case "string": {
                            property2 = new Formula().stringValue(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(formulaObject, "string"));
                            break block0;
                        }
                        case "number": {
                            property2 = new Formula().numberValue(CustomDeserializerUtils.getAsDoubleIfPresentAndNotNull(formulaObject, "number"));
                            break block0;
                        }
                        case "boolean": {
                            property2 = new Formula().booleanValue(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(formulaObject, "boolean"));
                            break block0;
                        }
                        case "date": {
                            property2 = new Formula().dateValue(new CustomOffsetDateTimeDeserializer().deserialize(formulaObject.get("date"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext));
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unexpected value: " + valueType);
                }
                case LAST_EDITED_BY: {
                    Property property2 = new LastEditedBy().user(new CustomUserDeserializer().deserialize(jsonObject.get("last_edited_by"), (Type)((Object)User.class), jsonDeserializationContext));
                    break;
                }
                case LAST_EDITED_TIME: {
                    Property property2 = new LastEditedTime().lastEditedTime(new CustomOffsetDateTimeDeserializer().deserialize(jsonObject.get("last_edited_time"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext));
                    break;
                }
                case MULTI_SELECT: {
                    Property property2 = new MultiSelect().selected(this.extractSelectItems(jsonObject));
                    break;
                }
                case NUMBER: {
                    Property property2 = new Number().number(CustomDeserializerUtils.getAsDoubleIfPresentAndNotNull(jsonObject, "number"));
                    break;
                }
                case PEOPLE: {
                    Property property2;
                    if (jsonObject.getAsJsonArray("people") == null || jsonObject.getAsJsonArray("people").isJsonNull()) {
                        property2 = null;
                        break;
                    }
                    property2 = new People().people(jsonObject.getAsJsonArray("people").asList().stream().map(person -> new CustomUserDeserializer().deserialize((JsonElement)person, (Type)((Object)User.class), jsonDeserializationContext)).toList());
                    break;
                }
                case PHONE_NUMBER: {
                    Property property2 = new PhoneNumber().phoneNumber(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "phone_number"));
                    break;
                }
                case RELATION: {
                    Property property2;
                    if (jsonObject.getAsJsonObject("relation") == null || jsonObject.getAsJsonObject("relation").isJsonNull()) {
                        property2 = null;
                        break;
                    }
                    property2 = new Relation().relatedPageIds(jsonObject.getAsJsonArray("relation").asList().stream().map(relation -> CustomDeserializerUtils.getAsStringIfPresentAndNotNull(relation.getAsJsonObject(), "id")).toList());
                    break;
                }
                case RICH_TEXT: {
                    Property property2 = new RichText().content((List<de.flix29.notionApiClient.model.RichText>)new CustomRichTextDeserializer().deserialize((JsonElement)jsonObject.getAsJsonObject("results"), (Type)((Object)de.flix29.notionApiClient.model.RichText.class), jsonDeserializationContext));
                    break;
                }
                case ROLLUP: {
                    Property property2 = new Rollup();
                    break;
                }
                case SELECT: {
                    Property property2 = new Select().selected(this.extractSelectItem((JsonElement)jsonObject.getAsJsonObject("select")));
                    break;
                }
                case STATUS: {
                    Property property2 = new Status().selectedOption(this.extractStatusItem(jsonObject.getAsJsonObject("status")));
                    break;
                }
                case TITLE: {
                    Property property2 = new Title().title((List<de.flix29.notionApiClient.model.RichText>)new CustomRichTextDeserializer().deserialize((JsonElement)jsonObject.getAsJsonArray(propertyType.getType()), (Type)((Object)de.flix29.notionApiClient.model.RichText.class), jsonDeserializationContext));
                    break;
                }
                case URL: {
                    Property property2 = property = new Url().url(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "url"));
                }
            }
            if (property == null) {
                return null;
            }
            return property.id(id).name(name);
        }).toList();
    }

    private List<SelectItem> extractSelectItems(JsonObject jsonObject) {
        if (jsonObject == null || jsonObject.isJsonNull() || !jsonObject.has("multi_select") || jsonObject.get("multi_select").isJsonNull()) {
            return null;
        }
        return jsonObject.getAsJsonArray("multi_select").asList().stream().filter(Objects::nonNull).map(this::extractSelectItem).toList();
    }

    private SelectItem extractSelectItem(JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        return new SelectItem().id(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "id")).name(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "name")).color(Color.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "color")));
    }

    private StatusItem extractStatusItem(JsonObject jsonObject) {
        return new StatusItem(false).id(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "id")).name(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "name")).color(Color.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "color")));
    }
}

