/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient.customDeserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.flix29.notionApiClient.customDeserializer.CustomDeserializerUtils;
import de.flix29.notionApiClient.customDeserializer.CustomFileDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomIconDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomModelTypes;
import de.flix29.notionApiClient.customDeserializer.CustomOffsetDateTimeDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomPagePropertiesDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomParentDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomUserDeserializer;
import de.flix29.notionApiClient.model.File;
import de.flix29.notionApiClient.model.Icon;
import de.flix29.notionApiClient.model.Parent;
import de.flix29.notionApiClient.model.User;
import de.flix29.notionApiClient.model.database.databaseProperty.Property;
import de.flix29.notionApiClient.model.page.Page;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;

public class CustomPageDeserializer
implements JsonDeserializer<Page> {
    public Page deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject == null || jsonObject.isJsonNull()) {
            return null;
        }
        return new Page().id(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "id")).createdTime(new CustomOffsetDateTimeDeserializer().deserialize(jsonObject.get("created_time"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext)).lastEditedTime(new CustomOffsetDateTimeDeserializer().deserialize(jsonObject.get("last_edited_time"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext)).createdBy(new CustomUserDeserializer().deserialize(jsonObject.get("created_by"), (Type)((Object)User.class), jsonDeserializationContext)).lastEditedBy(new CustomUserDeserializer().deserialize(jsonObject.get("last_edited_by"), (Type)((Object)User.class), jsonDeserializationContext)).archived(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonObject, "archived")).deleted(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonObject, "in_trash")).icon(new CustomIconDeserializer().deserialize(jsonObject.get("icon"), (Type)((Object)Icon.class), jsonDeserializationContext)).cover(new CustomFileDeserializer().deserialize(jsonObject.get("cover"), (Type)((Object)File.class), jsonDeserializationContext)).properties((List<Property>)new CustomPagePropertiesDeserializer().deserialize(jsonObject.get("properties"), CustomModelTypes.PROPERTY_LIST_TYPE, jsonDeserializationContext)).parent(new CustomParentDeserializer().deserialize(jsonObject.get("parent"), (Type)((Object)Parent.class), jsonDeserializationContext)).url(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "url")).publicUrl(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "public_url"));
    }
}

