/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient.customDeserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.flix29.notionApiClient.customDeserializer.CustomDeserializerUtils;
import de.flix29.notionApiClient.customDeserializer.CustomFileDeserializer;
import de.flix29.notionApiClient.model.Emoji;
import de.flix29.notionApiClient.model.File;
import de.flix29.notionApiClient.model.Icon;
import java.lang.reflect.Type;

public class CustomIconDeserializer
implements JsonDeserializer<Icon> {
    public Icon deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String iconType = CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "type");
        if (iconType == null) {
            throw new JsonParseException("Icon type is missing");
        }
        return switch (iconType) {
            case "file", "external" -> new CustomFileDeserializer().deserialize(jsonElement, (Type)((Object)File.class), jsonDeserializationContext);
            case "emoji" -> new Emoji(CustomDeserializerUtils.getStringFromJsonElement(jsonElement, "emoji"));
            default -> throw new JsonParseException("Unknown icon type: " + iconType);
        };
    }
}

