/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient.customDeserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.flix29.notionApiClient.customDeserializer.CustomDeserializerUtils;
import de.flix29.notionApiClient.customDeserializer.CustomOffsetDateTimeDeserializer;
import de.flix29.notionApiClient.model.File;
import de.flix29.notionApiClient.model.FileType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;

public class CustomFileDeserializer
implements JsonDeserializer<File> {
    public File deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String fileType = CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "type");
        JsonObject fileObject = jsonObject.getAsJsonObject(fileType);
        return new File().type(FileType.fromString(fileType)).url(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(fileObject, "url")).expirationTime(new CustomOffsetDateTimeDeserializer().deserialize(fileObject.get("expiry_time"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext));
    }
}

