/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient.customDeserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.flix29.notionApiClient.customDeserializer.CustomDeserializerUtils;
import de.flix29.notionApiClient.model.Color;
import de.flix29.notionApiClient.model.database.databaseProperty.Button;
import de.flix29.notionApiClient.model.database.databaseProperty.Checkbox;
import de.flix29.notionApiClient.model.database.databaseProperty.CreatedBy;
import de.flix29.notionApiClient.model.database.databaseProperty.CreatedTime;
import de.flix29.notionApiClient.model.database.databaseProperty.Date;
import de.flix29.notionApiClient.model.database.databaseProperty.Email;
import de.flix29.notionApiClient.model.database.databaseProperty.File;
import de.flix29.notionApiClient.model.database.databaseProperty.Formula;
import de.flix29.notionApiClient.model.database.databaseProperty.LastEditedBy;
import de.flix29.notionApiClient.model.database.databaseProperty.LastEditedTime;
import de.flix29.notionApiClient.model.database.databaseProperty.MultiSelect;
import de.flix29.notionApiClient.model.database.databaseProperty.Number;
import de.flix29.notionApiClient.model.database.databaseProperty.NumberFormat;
import de.flix29.notionApiClient.model.database.databaseProperty.People;
import de.flix29.notionApiClient.model.database.databaseProperty.PhoneNumber;
import de.flix29.notionApiClient.model.database.databaseProperty.Property;
import de.flix29.notionApiClient.model.database.databaseProperty.PropertyType;
import de.flix29.notionApiClient.model.database.databaseProperty.Relation;
import de.flix29.notionApiClient.model.database.databaseProperty.RichText;
import de.flix29.notionApiClient.model.database.databaseProperty.Rollup;
import de.flix29.notionApiClient.model.database.databaseProperty.RollupFunction;
import de.flix29.notionApiClient.model.database.databaseProperty.Select;
import de.flix29.notionApiClient.model.database.databaseProperty.SelectItem;
import de.flix29.notionApiClient.model.database.databaseProperty.Status;
import de.flix29.notionApiClient.model.database.databaseProperty.StatusItem;
import de.flix29.notionApiClient.model.database.databaseProperty.Title;
import de.flix29.notionApiClient.model.database.databaseProperty.Url;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CustomDatabasePropertiesDeserializer
implements JsonDeserializer<List<Property>> {
    public List<Property> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        ArrayList<Property> output = new ArrayList<Property>();
        Set entries = jsonElement.getAsJsonObject().entrySet();
        if (entries == null || entries.isEmpty()) {
            return output;
        }
        entries.stream().filter(Objects::nonNull).forEach(entry -> {
            if (entry.getKey() == null || entry.getValue() == null || ((JsonElement)entry.getValue()).isJsonNull()) {
                return;
            }
            JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            PropertyType propertyType = PropertyType.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "type"));
            String id = CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "id");
            String name = CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "name");
            Property property = switch (propertyType) {
                default -> throw new MatchException(null, null);
                case PropertyType.BUTTON -> new Button();
                case PropertyType.CHECKBOX -> new Checkbox();
                case PropertyType.CREATED_BY -> new CreatedBy();
                case PropertyType.CREATED_TIME -> new CreatedTime();
                case PropertyType.DATE -> new Date();
                case PropertyType.EMAIL -> new Email();
                case PropertyType.FILE -> new File();
                case PropertyType.FORMULA -> new Formula().expression(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject.getAsJsonObject("formula"), "expression"));
                case PropertyType.LAST_EDITED_BY -> new LastEditedBy();
                case PropertyType.LAST_EDITED_TIME -> new LastEditedTime();
                case PropertyType.MULTI_SELECT -> new MultiSelect().options(this.extractSelectItems(jsonObject.getAsJsonObject("multi_select")));
                case PropertyType.NUMBER -> {
                    String format = CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject.getAsJsonObject("number"), "format");
                    yield new Number().format(NumberFormat.valueOf(format));
                }
                case PropertyType.PEOPLE -> new People();
                case PropertyType.PHONE_NUMBER -> new PhoneNumber();
                case PropertyType.RELATION -> {
                    JsonObject relationObject = jsonObject.getAsJsonObject("relation");
                    Relation relation = new Relation().databaseId(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(relationObject, "database_id"));
                    String relationType = CustomDeserializerUtils.getAsStringIfPresentAndNotNull(relationObject, "type");
                    if (relationType != null && relationType.equals("dual_property")) {
                        JsonObject dualProperty = relationObject.get("dual_property").getAsJsonObject();
                        relation.syncedPropertyName(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(dualProperty, "synced_property_name")).syncedPropertyId(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(dualProperty, "synced_property_id"));
                    }
                    yield relation;
                }
                case PropertyType.RICH_TEXT -> new RichText();
                case PropertyType.ROLLUP -> {
                    JsonObject rollup = jsonObject.getAsJsonObject("rollup");
                    yield new Rollup().relationPropertyName(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(rollup, "relation_property_name")).rollupPropertyName(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(rollup, "rollup_property_name")).relationPropertyId(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(rollup, "relation_property_id")).rollupPropertyId(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(rollup, "rollup_property_id")).function(RollupFunction.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(rollup, "function")));
                }
                case PropertyType.SELECT -> new Select().options(this.extractSelectItems(jsonObject.getAsJsonObject("select")));
                case PropertyType.STATUS -> new Status().options(this.extractStatusItems(jsonObject.getAsJsonObject("status"), "options", false)).groups(this.extractStatusItems(jsonObject.getAsJsonObject("status"), "groups", true));
                case PropertyType.TITLE -> new Title();
                case PropertyType.URL -> new Url();
            };
            property = property.id(id).name(name).description((String)entry.getKey());
            output.add(property);
        });
        return output;
    }

    private List<SelectItem> extractSelectItems(JsonObject jsonObject) {
        if (jsonObject == null || jsonObject.isJsonNull()) {
            return Collections.emptyList();
        }
        return jsonObject.get("options").getAsJsonArray().asList().stream().filter(Objects::nonNull).map(option -> {
            JsonObject optionObject = option.getAsJsonObject();
            return new SelectItem().id(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(optionObject, "id")).name(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(optionObject, "name")).color(Color.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(optionObject, "color")));
        }).toList();
    }

    private List<StatusItem> extractStatusItems(JsonObject jsonObject, String type, boolean isGroup) {
        if (jsonObject == null || jsonObject.isJsonNull() || jsonObject.get(type) == null || jsonObject.get(type).isJsonNull()) {
            return Collections.emptyList();
        }
        return jsonObject.get(type).getAsJsonArray().asList().stream().filter(Objects::nonNull).map(option -> {
            JsonObject optionObject = option.getAsJsonObject();
            return new StatusItem(isGroup).id(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(optionObject, "id")).name(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(optionObject, "name")).color(Color.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(optionObject, "color"))).optionIds(isGroup ? CustomDatabasePropertiesDeserializer.getOptionIds(optionObject) : Collections.emptyList());
        }).toList();
    }

    private static List<String> getOptionIds(JsonObject optionObject) {
        if (optionObject == null || optionObject.isJsonNull() || optionObject.get("option_ids") == null || optionObject.get("option_ids").isJsonNull()) {
            return Collections.emptyList();
        }
        return optionObject.get("option_ids").getAsJsonArray().asList().stream().filter(Objects::nonNull).map(JsonElement::getAsString).toList();
    }
}

