/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient.customDeserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.flix29.notionApiClient.customDeserializer.CustomDatabasePropertiesDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomDeserializerUtils;
import de.flix29.notionApiClient.customDeserializer.CustomFileDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomIconDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomModelTypes;
import de.flix29.notionApiClient.customDeserializer.CustomOffsetDateTimeDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomParentDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomRichTextDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomUserDeserializer;
import de.flix29.notionApiClient.model.File;
import de.flix29.notionApiClient.model.Icon;
import de.flix29.notionApiClient.model.Parent;
import de.flix29.notionApiClient.model.RichText;
import de.flix29.notionApiClient.model.User;
import de.flix29.notionApiClient.model.database.Database;
import de.flix29.notionApiClient.model.database.databaseProperty.Property;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;

public class CustomDatabaseDeserializer
implements JsonDeserializer<Database> {
    public Database deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject == null || jsonObject.isJsonNull()) {
            return null;
        }
        return new Database().id(CustomDeserializerUtils.getUUIDFromJsonElement((JsonElement)jsonObject, "id")).createdTime(new CustomOffsetDateTimeDeserializer().deserialize(jsonObject.get("created_time"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext)).createdBy(new CustomUserDeserializer().deserialize(jsonObject.get("created_by"), (Type)((Object)User.class), jsonDeserializationContext)).lastEditedTime(new CustomOffsetDateTimeDeserializer().deserialize(jsonObject.get("last_edited_time"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext)).lastEditedBy(new CustomUserDeserializer().deserialize(jsonObject.get("last_edited_by"), (Type)((Object)User.class), jsonDeserializationContext)).titel((List<RichText>)new CustomRichTextDeserializer().deserialize(jsonObject.get("title"), CustomModelTypes.RICH_TEXT_LIST_TYPE, jsonDeserializationContext)).description((List<RichText>)new CustomRichTextDeserializer().deserialize(jsonObject.get("description"), CustomModelTypes.RICH_TEXT_LIST_TYPE, jsonDeserializationContext)).inline(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonObject, "is_inline")).icon(new CustomIconDeserializer().deserialize(jsonObject.get("icon"), (Type)((Object)Icon.class), jsonDeserializationContext)).cover(new CustomFileDeserializer().deserialize(jsonObject.get("cover"), (Type)((Object)File.class), jsonDeserializationContext)).properties((List<Property>)new CustomDatabasePropertiesDeserializer().deserialize(jsonObject.get("properties"), CustomModelTypes.PROPERTY_LIST_TYPE, jsonDeserializationContext)).parent(new CustomParentDeserializer().deserialize(jsonObject.get("parent"), (Type)((Object)Parent.class), jsonDeserializationContext)).url(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "url")).archived(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonObject, "archived")).deleted(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonObject, "in_trash")).publicUrl(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "public_url"));
    }
}

