/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient.customDeserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.flix29.notionApiClient.customDeserializer.CustomBlockContentDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomDeserializerUtils;
import de.flix29.notionApiClient.customDeserializer.CustomOffsetDateTimeDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomParentDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomUserDeserializer;
import de.flix29.notionApiClient.model.Parent;
import de.flix29.notionApiClient.model.User;
import de.flix29.notionApiClient.model.block.Block;
import de.flix29.notionApiClient.model.block.BlockType;
import de.flix29.notionApiClient.model.block.blockContent.BlockContent;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;

public class CustomBlockDeserializer
implements JsonDeserializer<Block> {
    public Block deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        BlockType blockType = BlockType.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonObject, "type"));
        return new Block().id(CustomDeserializerUtils.getUUIDFromJsonElement((JsonElement)jsonObject, "id")).parent(new CustomParentDeserializer().deserialize(jsonObject.get("parent"), (Type)((Object)Parent.class), jsonDeserializationContext)).createdTime(new CustomOffsetDateTimeDeserializer().deserialize(jsonObject.get("created_time"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext)).lastEditedTime(new CustomOffsetDateTimeDeserializer().deserialize(jsonObject.get("last_edited_time"), (Type)((Object)OffsetDateTime.class), jsonDeserializationContext)).createdBy(new CustomUserDeserializer().deserialize(jsonObject.get("created_by"), (Type)((Object)User.class), jsonDeserializationContext)).lastEditedBy(new CustomUserDeserializer().deserialize(jsonObject.get("last_edited_by"), (Type)((Object)User.class), jsonDeserializationContext)).hasChildren(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonObject, "has_children")).archived(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonObject, "archived")).deleted(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonObject, "in_trash")).type(blockType).blockContent(new CustomBlockContentDeserializer().deserialize(jsonObject.get(blockType.getType()), (Type)((Object)BlockContent.class), jsonDeserializationContext, blockType));
    }
}

