/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient.customDeserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.flix29.notionApiClient.customDeserializer.CustomDeserializerUtils;
import de.flix29.notionApiClient.customDeserializer.CustomIconDeserializer;
import de.flix29.notionApiClient.model.FileType;
import de.flix29.notionApiClient.model.Icon;
import de.flix29.notionApiClient.model.block.BlockType;
import de.flix29.notionApiClient.model.block.blockContent.BlockContent;
import de.flix29.notionApiClient.model.block.blockContent.Bookmark;
import de.flix29.notionApiClient.model.block.blockContent.Breadcrumb;
import de.flix29.notionApiClient.model.block.blockContent.BulletListItem;
import de.flix29.notionApiClient.model.block.blockContent.Callout;
import de.flix29.notionApiClient.model.block.blockContent.ChildDatabase;
import de.flix29.notionApiClient.model.block.blockContent.ChildPage;
import de.flix29.notionApiClient.model.block.blockContent.Column;
import de.flix29.notionApiClient.model.block.blockContent.ColumnList;
import de.flix29.notionApiClient.model.block.blockContent.Divider;
import de.flix29.notionApiClient.model.block.blockContent.Embed;
import de.flix29.notionApiClient.model.block.blockContent.Equation;
import de.flix29.notionApiClient.model.block.blockContent.File;
import de.flix29.notionApiClient.model.block.blockContent.Heading;
import de.flix29.notionApiClient.model.block.blockContent.Image;
import de.flix29.notionApiClient.model.block.blockContent.LinkPreview;
import de.flix29.notionApiClient.model.block.blockContent.NumberedListItem;
import de.flix29.notionApiClient.model.block.blockContent.Paragraph;
import de.flix29.notionApiClient.model.block.blockContent.Pdf;
import de.flix29.notionApiClient.model.block.blockContent.Quote;
import de.flix29.notionApiClient.model.block.blockContent.SyncedBlock;
import de.flix29.notionApiClient.model.block.blockContent.Table;
import de.flix29.notionApiClient.model.block.blockContent.TableOfContents;
import de.flix29.notionApiClient.model.block.blockContent.TableRow;
import de.flix29.notionApiClient.model.block.blockContent.ToDo;
import de.flix29.notionApiClient.model.block.blockContent.Toggle;
import de.flix29.notionApiClient.model.block.blockContent.Video;
import java.lang.reflect.Type;

public class CustomBlockContentDeserializer
implements JsonDeserializer<BlockContent> {
    private BlockType blockType = BlockType.UNSUPPORTED;

    public BlockContent deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext, BlockType blockType) {
        if (jsonElement == null || jsonElement.isJsonNull() || blockType == null) {
            return null;
        }
        this.blockType = blockType;
        return this.deserialize(jsonElement, type, jsonDeserializationContext);
    }

    public BlockContent deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return switch (this.blockType) {
            default -> throw new MatchException(null, null);
            case BlockType.BOOKMARK -> new Bookmark().caption(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "caption", jsonDeserializationContext)).url(CustomDeserializerUtils.getStringFromJsonElement(jsonElement, "url"));
            case BlockType.BREADCRUMB -> new Breadcrumb();
            case BlockType.BULLETED_LIST_ITEM -> new BulletListItem().content(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "rich_text", jsonDeserializationContext)).color(CustomDeserializerUtils.getColorFromJsonElement(jsonElement));
            case BlockType.CALLOUT -> new Callout().content(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "rich_text", jsonDeserializationContext)).icon(new CustomIconDeserializer().deserialize(jsonElement.getAsJsonObject().get("icon"), (Type)((Object)Icon.class), jsonDeserializationContext)).color(CustomDeserializerUtils.getColorFromJsonElement(jsonElement));
            case BlockType.CHILD_DATABASE -> new ChildDatabase().title(CustomDeserializerUtils.getStringFromJsonElement(jsonElement, "title"));
            case BlockType.CHILD_PAGE -> new ChildPage().title(CustomDeserializerUtils.getStringFromJsonElement(jsonElement, "title"));
            case BlockType.COLUMN -> new Column();
            case BlockType.COLUMN_LIST -> new ColumnList();
            case BlockType.DIVIDER -> new Divider();
            case BlockType.EMBED -> new Embed().caption(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "caption", jsonDeserializationContext)).url(CustomDeserializerUtils.getStringFromJsonElement(jsonElement, "url"));
            case BlockType.EQUATION -> new Equation().expression(CustomDeserializerUtils.getStringFromJsonElement(jsonElement.getAsJsonObject().get("equation"), "expression"));
            case BlockType.FILE -> new File().caption(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "caption", jsonDeserializationContext)).file(CustomDeserializerUtils.getFileFromJsonElement(jsonElement, jsonDeserializationContext)).name(CustomDeserializerUtils.getStringFromJsonElement(jsonElement, "name"));
            case BlockType.HEADING_1 -> this.createHeading(jsonElement, 1, jsonDeserializationContext);
            case BlockType.HEADING_2 -> this.createHeading(jsonElement, 2, jsonDeserializationContext);
            case BlockType.HEADING_3 -> this.createHeading(jsonElement, 3, jsonDeserializationContext);
            case BlockType.IMAGE -> new Image().caption(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "caption", jsonDeserializationContext)).file(CustomDeserializerUtils.getFileFromJsonElement(jsonElement, jsonDeserializationContext));
            case BlockType.LINK_PREVIEW -> new LinkPreview().url(CustomDeserializerUtils.getStringFromJsonElement(jsonElement, "url"));
            case BlockType.LINK_TO_PAGE, BlockType.TEMPLATE -> null;
            case BlockType.NUMBERED_LIST_ITEM -> new NumberedListItem().content(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "rich_text", jsonDeserializationContext)).color(CustomDeserializerUtils.getColorFromJsonElement(jsonElement));
            case BlockType.PARAGRAPH -> new Paragraph().content(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "rich_text", jsonDeserializationContext)).color(CustomDeserializerUtils.getColorFromJsonElement(jsonElement));
            case BlockType.PDF -> new Pdf().caption(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "caption", jsonDeserializationContext)).type(FileType.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonElement.getAsJsonObject(), "type"))).file(CustomDeserializerUtils.getFileFromJsonElement(jsonElement, jsonDeserializationContext));
            case BlockType.QUOTE -> new Quote().content(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "rich_text", jsonDeserializationContext)).color(CustomDeserializerUtils.getColorFromJsonElement(jsonElement));
            case BlockType.SYNCED_BLOCK -> this.buildSyncedBlock(jsonElement);
            case BlockType.TABLE -> new Table().tableWidth(CustomDeserializerUtils.getAsIntegerIfPresentAndNotNull(jsonElement.getAsJsonObject(), "table_width")).hasColumnHeader(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonElement.getAsJsonObject(), "has_column_header")).hasRowHeader(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonElement.getAsJsonObject(), "has_row_header"));
            case BlockType.TABLE_OF_CONTENTS -> new TableOfContents().color(CustomDeserializerUtils.getColorFromJsonElement(jsonElement));
            case BlockType.TABLE_ROW -> new TableRow();
            case BlockType.TO_DO -> new ToDo().content(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "rich_text", jsonDeserializationContext)).checked(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonElement.getAsJsonObject(), "checked")).color(CustomDeserializerUtils.getColorFromJsonElement(jsonElement));
            case BlockType.TOGGLE -> new Toggle().content(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "rich_text", jsonDeserializationContext)).color(CustomDeserializerUtils.getColorFromJsonElement(jsonElement));
            case BlockType.UNSUPPORTED -> throw new UnsupportedOperationException("Unsupported block type");
            case BlockType.VIDEO -> new Video().caption(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "caption", jsonDeserializationContext)).type(FileType.fromString(CustomDeserializerUtils.getAsStringIfPresentAndNotNull(jsonElement.getAsJsonObject(), "type"))).file(CustomDeserializerUtils.getFileFromJsonElement(jsonElement, jsonDeserializationContext));
        };
    }

    private Heading createHeading(JsonElement jsonElement, int level, JsonDeserializationContext jsonDeserializationContext) {
        return new Heading(level).content(CustomDeserializerUtils.getRichTextFromJsonElement(jsonElement, "rich_text", jsonDeserializationContext)).color(CustomDeserializerUtils.getColorFromJsonElement(jsonElement)).isToggleable(CustomDeserializerUtils.getAsBooleanIfPresentAndNotNull(jsonElement.getAsJsonObject(), "is_toggleable"));
    }

    private SyncedBlock buildSyncedBlock(JsonElement jsonElement) {
        SyncedBlock syncedBlock = new SyncedBlock();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.get("synced_from") != null && !jsonObject.get("synced_from").isJsonNull()) {
            return syncedBlock.syncedFrom(jsonObject.get("synced_from").getAsJsonObject().get("block_id").getAsString());
        }
        return syncedBlock;
    }
}

