/*
 * Decompiled with CFR 0.152.
 */
package de.flix29.notionApiClient;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.flix29.notionApiClient.customDeserializer.CustomBlockDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomBlockListDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomDatabaseDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomModelTypes;
import de.flix29.notionApiClient.customDeserializer.CustomPageDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomUserDeserializer;
import de.flix29.notionApiClient.customDeserializer.CustomUserListDeserializer;
import de.flix29.notionApiClient.model.User;
import de.flix29.notionApiClient.model.block.Block;
import de.flix29.notionApiClient.model.database.Database;
import de.flix29.notionApiClient.model.database.databaseProperty.Property;
import de.flix29.notionApiClient.model.page.Page;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;

public class NotionClient {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Database.class, (Object)new CustomDatabaseDeserializer()).registerTypeAdapter(Block.class, (Object)new CustomBlockDeserializer()).registerTypeAdapter(CustomModelTypes.BLOCK_LIST_TYPE, (Object)new CustomBlockListDeserializer()).registerTypeAdapter(User.class, (Object)new CustomUserDeserializer()).registerTypeAdapter(CustomModelTypes.USER_LIST_TYPE, (Object)new CustomUserListDeserializer()).registerTypeAdapter(Page.class, (Object)new CustomPageDeserializer()).create();
    private final String NOTION_VERSION = "2022-06-28";
    private final String NOTION_API_URL = "https://api.notion.com/v1";
    private final String NOTION_DATABASE_URL = "https://api.notion.com/v1/databases/$id$";
    private final String NOTION_BLOCK_URL = "https://api.notion.com/v1/blocks/$id$";
    private final String NOTION_PAGE_URL = "https://api.notion.com/v1/pages/$id$";
    private final String NOTION_BLOCK_CHILDREN_URL = "https://api.notion.com/v1/blocks/$id$/children";
    private final String NOTION_USERS_URL = "https://api.notion.com/v1/users";
    private final HttpRequest.Builder requestBuilder;

    public NotionClient(String apikey) {
        if (apikey == null || apikey.isEmpty()) {
            throw new IllegalArgumentException("API key must not be null or empty");
        }
        this.requestBuilder = HttpRequest.newBuilder().header("Authorization", apikey).header("Notion-Version", "2022-06-28").header("Content-Type", "application/json").method("GET", HttpRequest.BodyPublishers.noBody());
    }

    public Database getDatabase(String databaseId) throws IOException, InterruptedException {
        String databaseUri = this.buildUri("https://api.notion.com/v1/databases/$id$", databaseId);
        HttpRequest builder = this.requestBuilder.uri(URI.create(databaseUri)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(builder, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("Notion response error: " + response.statusCode() + " - " + response.body());
        }
        return (Database)this.gson.fromJson(response.body(), Database.class);
    }

    public Block getBlock(String blockId) throws IOException, InterruptedException {
        String blockUri = this.buildUri("https://api.notion.com/v1/blocks/$id$", blockId);
        HttpRequest builder = this.requestBuilder.uri(URI.create(blockUri)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(builder, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("Notion response error: " + response.statusCode() + " - " + response.body());
        }
        return (Block)this.gson.fromJson(response.body(), Block.class);
    }

    public List<Block> getBlockChildren(String blockId) throws IOException, InterruptedException {
        String blockUri = this.buildUri("https://api.notion.com/v1/blocks/$id$/children", blockId);
        HttpRequest builder = this.requestBuilder.uri(URI.create(blockUri)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(builder, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("Notion response error: " + response.statusCode() + " - " + response.body());
        }
        return (List)this.gson.fromJson(response.body(), CustomModelTypes.BLOCK_LIST_TYPE);
    }

    public List<Block> getBlockChildrenRecursive(String blockId) throws IOException, InterruptedException {
        String blockUri = this.buildUri("https://api.notion.com/v1/blocks/$id$/children", blockId);
        HttpRequest builder = this.requestBuilder.uri(URI.create(blockUri)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(builder, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("Notion response error: " + response.statusCode() + " - " + response.body());
        }
        List blocks = (List)this.gson.fromJson(response.body(), CustomModelTypes.BLOCK_LIST_TYPE);
        blocks.forEach(block -> {
            if (block.isHasChildren()) {
                try {
                    block.getBlockContent().setChildren(this.getBlockChildrenRecursive(String.valueOf(block.getId())));
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
        });
        return blocks;
    }

    public Page getPageProperties(String pageId) throws IOException, InterruptedException {
        String pageUri = this.buildUri("https://api.notion.com/v1/pages/$id$", pageId);
        HttpRequest builder = this.requestBuilder.uri(URI.create(pageUri)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(builder, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("Notion response error: " + response.statusCode() + " - " + response.body());
        }
        return (Page)this.gson.fromJson(response.body(), Page.class);
    }

    public Property getPageProperty(String pageId, String propertyId) throws IOException, InterruptedException {
        Page page = this.getPageProperties(pageId);
        return page.getProperties().stream().filter(property -> property.getId().equals(propertyId)).findFirst().orElse(null);
    }

    public List<User> listAllUsers() throws IOException, InterruptedException {
        HttpRequest builder = this.requestBuilder.uri(URI.create("https://api.notion.com/v1/users")).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(builder, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("Notion response error: " + response.statusCode() + " - " + response.body());
        }
        return (List)this.gson.fromJson(response.body(), CustomModelTypes.USER_LIST_TYPE);
    }

    public User getUser(String userId) throws IOException, InterruptedException {
        String userUri = "https://api.notion.com/v1/users/" + userId;
        HttpRequest builder = this.requestBuilder.uri(URI.create(userUri)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(builder, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("Notion response error: " + response.statusCode() + " - " + response.body());
        }
        return (User)this.gson.fromJson(response.body(), User.class);
    }

    public User getCurrentUser() throws IOException, InterruptedException {
        String userUri = "https://api.notion.com/v1/users/me";
        HttpRequest builder = this.requestBuilder.uri(URI.create(userUri)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(builder, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("Notion response error: " + response.statusCode() + " - " + response.body());
        }
        return (User)this.gson.fromJson(response.body(), User.class);
    }

    private String buildUri(String url, String id) {
        return url.replace("$id$", id);
    }
}

