/*
 * Decompiled with CFR 0.152.
 */
package de.flexguse.util.junit;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;

public class ValidationViolationChecker<T> {
    private static final String LIST_DELIMITER = ", ";

    public void checkExpectedValidationViolations(Set<ConstraintViolation<T>> violations, List<String> expectedValidationViolations) {
        if (violations != null && expectedValidationViolations != null) {
            ArrayList<String> givenViolations = new ArrayList<String>();
            for (ConstraintViolation<T> violation : violations) {
                givenViolations.add(violation.getMessageTemplate());
            }
            ValidationViolationChecker.checkViolations(givenViolations, expectedValidationViolations);
        }
    }

    public static void checkExpectedValidationViolations(ConstraintViolationException exception, List<String> expectedValidationViolations) {
        if (exception != null && expectedValidationViolations != null) {
            ArrayList<String> givenViolations = new ArrayList<String>();
            for (ConstraintViolation violation : exception.getConstraintViolations()) {
                givenViolations.add(violation.getMessageTemplate());
            }
            ValidationViolationChecker.checkViolations(givenViolations, expectedValidationViolations);
        }
    }

    private static void checkViolations(List<String> givenViolations, List<String> expectedValidationViolations) {
        Assert.assertEquals((String)String.format("number of expected validation violations (%s) does not match the number of given violations (%s)", StringUtils.join(expectedValidationViolations, (String)LIST_DELIMITER), StringUtils.join(givenViolations, (String)LIST_DELIMITER)), (long)expectedValidationViolations.size(), (long)givenViolations.size());
        boolean listsAreCongruent = true;
        ArrayList<String> givenButNotExpected = new ArrayList<String>();
        for (String givenViolation : givenViolations) {
            if (expectedValidationViolations.contains(givenViolation)) continue;
            listsAreCongruent = false;
            givenButNotExpected.add(givenViolation);
        }
        Assert.assertTrue((String)String.format("the violations (%s) where given but not expected: all given violations (%s), all expected violations (%s)", StringUtils.join(givenButNotExpected, (String)LIST_DELIMITER), StringUtils.join(givenViolations, (String)LIST_DELIMITER), StringUtils.join(expectedValidationViolations, (String)LIST_DELIMITER)), (boolean)listsAreCongruent);
    }
}

