/**
 * Copyright (C) 2011
 *   Michael Mosmann <michael@mosmann.de>
 *   Jan Bernitt <unknown@email.de>
 *
 * with contributions from
 * 	nobody yet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.flapdoodle.tests.sampler;

import java.util.Collection;
import java.util.Iterator;


public class ImmutableListIterator<T> implements Iterator<T> {

	private Iterator<T> _iterator;

	public ImmutableListIterator(Collection<T> source) {
		_iterator = source.iterator();
	}

	@Override
	public boolean hasNext() {
		return _iterator.hasNext();
	}

	@Override
	public T next() {
		return _iterator.next();
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException("remove does not make any sense");
	}
	
	
}
