/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.wicket.serialize.java;

import de.flapdoodle.wicket.serialize.java.ISerializableCheck;
import de.flapdoodle.wicket.serialize.java.PreSerializeChecker;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.io.SerializableChecker;
import org.apache.wicket.serialize.java.JavaSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckingJavaSerializer
extends JavaSerializer {
    private static final Logger log = LoggerFactory.getLogger(JavaSerializer.class);
    private final ISerializableCheck serializableCheck;

    public CheckingJavaSerializer(String applicationKey, ISerializableCheck serializableCheck) {
        super(applicationKey);
        this.serializableCheck = serializableCheck;
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws IOException {
        return new PreCheckingObjectOutputStream(out, this.serializableCheck);
    }

    private static class PreCheckingObjectOutputStream
    extends ObjectOutputStream {
        private final ObjectOutputStream oos;
        private final ISerializableCheck serializableCheck;

        public PreCheckingObjectOutputStream(OutputStream out, ISerializableCheck serializableCheck) throws IOException {
            this.serializableCheck = serializableCheck;
            this.oos = new ObjectOutputStream(out);
        }

        @Override
        protected final void writeObjectOverride(Object obj) throws IOException {
            try {
                if (PreSerializeChecker.isAvailable()) {
                    new PreSerializeChecker(this.serializableCheck).writeObject(obj);
                }
                this.oos.writeObject(obj);
            }
            catch (NotSerializableException nsx) {
                if (SerializableChecker.isAvailable()) {
                    new SerializableChecker(nsx).writeObject(obj);
                    throw nsx;
                }
                throw nsx;
            }
            catch (Exception e) {
                log.error("error writing object " + obj + ": " + e.getMessage(), (Throwable)e);
                throw new WicketRuntimeException((Throwable)e);
            }
        }

        @Override
        public void flush() throws IOException {
            this.oos.flush();
        }

        @Override
        public void close() throws IOException {
            this.oos.close();
        }
    }
}

