/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.wicket.detach;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.IDetachListener;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldInspectingDetachListener
implements IDetachListener {
    private static final Logger log = LoggerFactory.getLogger(FieldInspectingDetachListener.class);

    public void onDetach(Component component) {
        Class<?> clazz = component.getClass();
        List<Field> fields = this.getAllFields(clazz);
        IdentityHashMap<Object, Boolean> hitMap = new IdentityHashMap<Object, Boolean>();
        this.checkFields(this.typeName(clazz) + "[path=" + component.getPath() + "]", hitMap, component, fields);
    }

    private String typeName(Class<? extends Component> clazz) {
        return "" + clazz.getName() + (clazz.isAnonymousClass() ? "(" + clazz.getSuperclass().getName() + ")" : "");
    }

    private void checkFields(String id, Map<Object, Boolean> hitMap, Object component, List<Field> fields) {
        Component c;
        IModel model;
        for (Field f : fields) {
            if (!this.isWorthALook(f)) continue;
            try {
                LoadableDetachableModel ldm;
                f.setAccessible(true);
                Object value = f.get(component);
                if (hitMap.containsKey(value)) continue;
                hitMap.put(value, true);
                if (value == null) continue;
                if (value instanceof LoadableDetachableModel && (ldm = (LoadableDetachableModel)value).isAttached()) {
                    log.error(id + ": loadable model " + ldm + " in " + f + " is NOT detached ", (Throwable)new RuntimeException());
                }
                this.checkFields(id, hitMap, value, this.getAllFields(value.getClass()));
            }
            catch (IllegalArgumentException e) {
                log.error("get value", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("get value", (Throwable)e);
            }
        }
        if (component instanceof Component && (model = (c = (Component)component).getDefaultModel()) != null) {
            this.checkFields(id, hitMap, model, this.getAllFields(model.getClass()));
        }
    }

    private boolean isWorthALook(Field f) {
        Class<?> fieldType = f.getType();
        if (fieldType.isPrimitive()) {
            return false;
        }
        Package fieldPackage = fieldType.getPackage();
        if (fieldPackage != null && fieldPackage.getName().startsWith("java.lang.")) {
            return false;
        }
        if (Page.class.isAssignableFrom(fieldType)) {
            return false;
        }
        if (f.getDeclaringClass() == Component.class) {
            if (f.getName().equals("parent")) {
                return false;
            }
            if (f.getName().equals("data")) {
                return false;
            }
        }
        return !Modifier.isStatic(f.getModifiers());
    }

    private List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            fields.addAll(this.getAllFields(superclass));
        }
        return fields;
    }

    public void onDestroyListener() {
    }
}

