package de.flapdoodle.transition.routes;

import de.flapdoodle.transition.StateID;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link RoutesAsGraph.RouteAndVertex}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRouteAndVertex.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRouteAndVertex.of()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "RoutesAsGraph.RouteAndVertex"})
public final class ImmutableRouteAndVertex
    implements RoutesAsGraph.RouteAndVertex {
  private final StateID<?> start;
  private final Route<?> route;
  private final StateID<?> end;

  private ImmutableRouteAndVertex(
      StateID<?> start,
      Route<?> route,
      StateID<?> end) {
    this.start = Objects.requireNonNull(start, "start");
    this.route = Objects.requireNonNull(route, "route");
    this.end = Objects.requireNonNull(end, "end");
  }

  private ImmutableRouteAndVertex(
      ImmutableRouteAndVertex original,
      StateID<?> start,
      Route<?> route,
      StateID<?> end) {
    this.start = start;
    this.route = route;
    this.end = end;
  }

  /**
   * @return The value of the {@code start} attribute
   */
  @Override
  public StateID<?> start() {
    return start;
  }

  /**
   * @return The value of the {@code route} attribute
   */
  @Override
  public Route<?> route() {
    return route;
  }

  /**
   * @return The value of the {@code end} attribute
   */
  @Override
  public StateID<?> end() {
    return end;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoutesAsGraph.RouteAndVertex#start() start} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for start
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRouteAndVertex withStart(StateID<?> value) {
    if (this.start == value) return this;
    StateID<?> newValue = Objects.requireNonNull(value, "start");
    return new ImmutableRouteAndVertex(this, newValue, this.route, this.end);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoutesAsGraph.RouteAndVertex#route() route} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for route
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRouteAndVertex withRoute(Route<?> value) {
    if (this.route == value) return this;
    Route<?> newValue = Objects.requireNonNull(value, "route");
    return new ImmutableRouteAndVertex(this, this.start, newValue, this.end);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoutesAsGraph.RouteAndVertex#end() end} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for end
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRouteAndVertex withEnd(StateID<?> value) {
    if (this.end == value) return this;
    StateID<?> newValue = Objects.requireNonNull(value, "end");
    return new ImmutableRouteAndVertex(this, this.start, this.route, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRouteAndVertex} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRouteAndVertex
        && equalTo((ImmutableRouteAndVertex) another);
  }

  private boolean equalTo(ImmutableRouteAndVertex another) {
    return start.equals(another.start)
        && route.equals(another.route)
        && end.equals(another.end);
  }

  /**
   * Computes a hash code from attributes: {@code start}, {@code route}, {@code end}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + start.hashCode();
    h += (h << 5) + route.hashCode();
    h += (h << 5) + end.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RouteAndVertex} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RouteAndVertex{"
        + "start=" + start
        + ", route=" + route
        + ", end=" + end
        + "}";
  }

  /**
   * Construct a new immutable {@code RouteAndVertex} instance.
   * @param start The value for the {@code start} attribute
   * @param route The value for the {@code route} attribute
   * @param end The value for the {@code end} attribute
   * @return An immutable RouteAndVertex instance
   */
  public static ImmutableRouteAndVertex of(StateID<?> start, Route<?> route, StateID<?> end) {
    return new ImmutableRouteAndVertex(start, route, end);
  }

  /**
   * Creates an immutable copy of a {@link RoutesAsGraph.RouteAndVertex} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RouteAndVertex instance
   */
  public static ImmutableRouteAndVertex copyOf(RoutesAsGraph.RouteAndVertex instance) {
    if (instance instanceof ImmutableRouteAndVertex) {
      return (ImmutableRouteAndVertex) instance;
    }
    return ImmutableRouteAndVertex.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRouteAndVertex ImmutableRouteAndVertex}.
   * @return A new ImmutableRouteAndVertex builder
   */
  public static ImmutableRouteAndVertex.Builder builder() {
    return new ImmutableRouteAndVertex.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRouteAndVertex ImmutableRouteAndVertex}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_START = 0x1L;
    private static final long INIT_BIT_ROUTE = 0x2L;
    private static final long INIT_BIT_END = 0x4L;
    private long initBits = 0x7L;

    private StateID<?> start;
    private Route<?> route;
    private StateID<?> end;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RouteAndVertex} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RoutesAsGraph.RouteAndVertex instance) {
      Objects.requireNonNull(instance, "instance");
      start(instance.start());
      route(instance.route());
      end(instance.end());
      return this;
    }

    /**
     * Initializes the value for the {@link RoutesAsGraph.RouteAndVertex#start() start} attribute.
     * @param start The value for start 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder start(StateID<?> start) {
      this.start = Objects.requireNonNull(start, "start");
      initBits &= ~INIT_BIT_START;
      return this;
    }

    /**
     * Initializes the value for the {@link RoutesAsGraph.RouteAndVertex#route() route} attribute.
     * @param route The value for route 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder route(Route<?> route) {
      this.route = Objects.requireNonNull(route, "route");
      initBits &= ~INIT_BIT_ROUTE;
      return this;
    }

    /**
     * Initializes the value for the {@link RoutesAsGraph.RouteAndVertex#end() end} attribute.
     * @param end The value for end 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder end(StateID<?> end) {
      this.end = Objects.requireNonNull(end, "end");
      initBits &= ~INIT_BIT_END;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRouteAndVertex ImmutableRouteAndVertex}.
     * @return An immutable instance of RouteAndVertex
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRouteAndVertex build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRouteAndVertex(null, start, route, end);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_START) != 0) attributes.add("start");
      if ((initBits & INIT_BIT_ROUTE) != 0) attributes.add("route");
      if ((initBits & INIT_BIT_END) != 0) attributes.add("end");
      return "Cannot build RouteAndVertex, some of required attributes are not set " + attributes;
    }
  }
}
