package de.flapdoodle.transition.routes;

import de.flapdoodle.transition.StateID;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link PartingWay}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePartingWay.<S, A, B>builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "PartingWay<S, A, B>"})
public final class ImmutablePartingWay<S, A, B> implements PartingWay<S, A, B> {
  private final StateID<S> start;
  private final StateID<A> oneDestination;
  private final StateID<B> otherDestination;

  private ImmutablePartingWay(
      StateID<S> start,
      StateID<A> oneDestination,
      StateID<B> otherDestination) {
    this.start = start;
    this.oneDestination = oneDestination;
    this.otherDestination = otherDestination;
  }

  /**
   * @return The value of the {@code start} attribute
   */
  @Override
  public StateID<S> start() {
    return start;
  }

  /**
   * @return The value of the {@code oneDestination} attribute
   */
  @Override
  public StateID<A> oneDestination() {
    return oneDestination;
  }

  /**
   * @return The value of the {@code otherDestination} attribute
   */
  @Override
  public StateID<B> otherDestination() {
    return otherDestination;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PartingWay#start() start} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for start
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePartingWay<S, A, B> withStart(StateID<S> value) {
    if (this.start == value) return this;
    StateID<S> newValue = Objects.requireNonNull(value, "start");
    return new ImmutablePartingWay<S, A, B>(newValue, this.oneDestination, this.otherDestination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PartingWay#oneDestination() oneDestination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oneDestination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePartingWay<S, A, B> withOneDestination(StateID<A> value) {
    if (this.oneDestination == value) return this;
    StateID<A> newValue = Objects.requireNonNull(value, "oneDestination");
    return new ImmutablePartingWay<S, A, B>(this.start, newValue, this.otherDestination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PartingWay#otherDestination() otherDestination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for otherDestination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePartingWay<S, A, B> withOtherDestination(StateID<B> value) {
    if (this.otherDestination == value) return this;
    StateID<B> newValue = Objects.requireNonNull(value, "otherDestination");
    return new ImmutablePartingWay<S, A, B>(this.start, this.oneDestination, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePartingWay} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePartingWay<?, ?, ?>
        && equalTo((ImmutablePartingWay<S, A, B>) another);
  }

  private boolean equalTo(ImmutablePartingWay<S, A, B> another) {
    return start.equals(another.start)
        && oneDestination.equals(another.oneDestination)
        && otherDestination.equals(another.otherDestination);
  }

  /**
   * Computes a hash code from attributes: {@code start}, {@code oneDestination}, {@code otherDestination}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + start.hashCode();
    h += (h << 5) + oneDestination.hashCode();
    h += (h << 5) + otherDestination.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PartingWay} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PartingWay{"
        + "start=" + start
        + ", oneDestination=" + oneDestination
        + ", otherDestination=" + otherDestination
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PartingWay} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <S> generic parameter S
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param instance The instance to copy
   * @return A copied immutable PartingWay instance
   */
  public static <S, A, B> ImmutablePartingWay<S, A, B> copyOf(PartingWay<S, A, B> instance) {
    if (instance instanceof ImmutablePartingWay<?, ?, ?>) {
      return (ImmutablePartingWay<S, A, B>) instance;
    }
    return ImmutablePartingWay.<S, A, B>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePartingWay ImmutablePartingWay}.
   * @param <S> generic parameter S
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @return A new ImmutablePartingWay builder
   */
  public static <S, A, B> ImmutablePartingWay.Builder<S, A, B> builder() {
    return new ImmutablePartingWay.Builder<S, A, B>();
  }

  /**
   * Builds instances of type {@link ImmutablePartingWay ImmutablePartingWay}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder<S, A, B> {
    private static final long INIT_BIT_START = 0x1L;
    private static final long INIT_BIT_ONE_DESTINATION = 0x2L;
    private static final long INIT_BIT_OTHER_DESTINATION = 0x4L;
    private long initBits = 0x7L;

    private StateID<S> start;
    private StateID<A> oneDestination;
    private StateID<B> otherDestination;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PartingWay} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, A, B> from(PartingWay<S, A, B> instance) {
      Objects.requireNonNull(instance, "instance");
      start(instance.start());
      oneDestination(instance.oneDestination());
      otherDestination(instance.otherDestination());
      return this;
    }

    /**
     * Initializes the value for the {@link PartingWay#start() start} attribute.
     * @param start The value for start 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, A, B> start(StateID<S> start) {
      this.start = Objects.requireNonNull(start, "start");
      initBits &= ~INIT_BIT_START;
      return this;
    }

    /**
     * Initializes the value for the {@link PartingWay#oneDestination() oneDestination} attribute.
     * @param oneDestination The value for oneDestination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, A, B> oneDestination(StateID<A> oneDestination) {
      this.oneDestination = Objects.requireNonNull(oneDestination, "oneDestination");
      initBits &= ~INIT_BIT_ONE_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link PartingWay#otherDestination() otherDestination} attribute.
     * @param otherDestination The value for otherDestination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, A, B> otherDestination(StateID<B> otherDestination) {
      this.otherDestination = Objects.requireNonNull(otherDestination, "otherDestination");
      initBits &= ~INIT_BIT_OTHER_DESTINATION;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePartingWay ImmutablePartingWay}.
     * @return An immutable instance of PartingWay
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePartingWay<S, A, B> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePartingWay<S, A, B>(start, oneDestination, otherDestination);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_START) != 0) attributes.add("start");
      if ((initBits & INIT_BIT_ONE_DESTINATION) != 0) attributes.add("oneDestination");
      if ((initBits & INIT_BIT_OTHER_DESTINATION) != 0) attributes.add("otherDestination");
      return "Cannot build PartingWay, some of required attributes are not set " + attributes;
    }
  }
}
