package de.flapdoodle.transition.routes;

import de.flapdoodle.transition.StateID;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Bridge}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBridge.<S, D>builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "Bridge<S, D>"})
public final class ImmutableBridge<S, D> implements Bridge<S, D> {
  private final StateID<S> start;
  private final StateID<D> destination;

  private ImmutableBridge(StateID<S> start, StateID<D> destination) {
    this.start = start;
    this.destination = destination;
  }

  /**
   * @return The value of the {@code start} attribute
   */
  @Override
  public StateID<S> start() {
    return start;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<D> destination() {
    return destination;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Bridge#start() start} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for start
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBridge<S, D> withStart(StateID<S> value) {
    if (this.start == value) return this;
    StateID<S> newValue = Objects.requireNonNull(value, "start");
    return new ImmutableBridge<S, D>(newValue, this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Bridge#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBridge<S, D> withDestination(StateID<D> value) {
    if (this.destination == value) return this;
    StateID<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableBridge<S, D>(this.start, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBridge} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBridge<?, ?>
        && equalTo((ImmutableBridge<S, D>) another);
  }

  private boolean equalTo(ImmutableBridge<S, D> another) {
    return start.equals(another.start)
        && destination.equals(another.destination);
  }

  /**
   * Computes a hash code from attributes: {@code start}, {@code destination}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + start.hashCode();
    h += (h << 5) + destination.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Bridge} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Bridge{"
        + "start=" + start
        + ", destination=" + destination
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Bridge} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <S> generic parameter S
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable Bridge instance
   */
  public static <S, D> ImmutableBridge<S, D> copyOf(Bridge<S, D> instance) {
    if (instance instanceof ImmutableBridge<?, ?>) {
      return (ImmutableBridge<S, D>) instance;
    }
    return ImmutableBridge.<S, D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBridge ImmutableBridge}.
   * @param <S> generic parameter S
   * @param <D> generic parameter D
   * @param destination {@code destination} parameter
   * @return A new ImmutableBridge builder
   */
  public static <S, D> ImmutableBridge.Builder<S, D> builder(StateID<D> destination) {
    return new ImmutableBridge.Builder<S, D>(destination);
  }

  static <S, D> ImmutableBridge.Builder<S, D> builder() {
    return new ImmutableBridge.Builder<S, D>();
  }

  /**
   * Builds instances of type {@link ImmutableBridge ImmutableBridge}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder<S, D> {
    private static final long INIT_BIT_START = 0x1L;
    private static final long INIT_BIT_DESTINATION = 0x2L;
    private long initBits = 0x3L;

    private StateID<S> start;
    private StateID<D> destination;

    private Builder(StateID<D> destination) {
      destination(destination);
    }

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Bridge} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> from(Bridge<S, D> instance) {
      Objects.requireNonNull(instance, "instance");
      start(instance.start());
      destination(instance.destination());
      return this;
    }

    /**
     * Initializes the value for the {@link Bridge#start() start} attribute.
     * @param start The value for start 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> start(StateID<S> start) {
      this.start = Objects.requireNonNull(start, "start");
      initBits &= ~INIT_BIT_START;
      return this;
    }

    /**
     * Initializes the value for the {@link Bridge#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder<S, D> destination(StateID<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBridge ImmutableBridge}.
     * @return An immutable instance of Bridge
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBridge<S, D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBridge<S, D>(start, destination);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_START) != 0) attributes.add("start");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      return "Cannot build Bridge, some of required attributes are not set " + attributes;
    }
  }
}
