package de.flapdoodle.transition.processlike;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link ProcessListener.Helper}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHelper.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "ProcessListener.Helper"})
public final class ImmutableHelper implements ProcessListener.Helper {
  private final ProcessOnStateChange onStateChange;
  private final ProcessOnStateChangeFailedWithRetry onStateChangeFailedWithRetry;

  private ImmutableHelper(ImmutableHelper.Builder builder) {
    if (builder.onStateChange != null) {
      initShim.onStateChange(builder.onStateChange);
    }
    if (builder.onStateChangeFailedWithRetry != null) {
      initShim.onStateChangeFailedWithRetry(builder.onStateChangeFailedWithRetry);
    }
    this.onStateChange = initShim.onStateChange();
    this.onStateChangeFailedWithRetry = initShim.onStateChangeFailedWithRetry();
    this.initShim = null;
  }

  private ImmutableHelper(
      ProcessOnStateChange onStateChange,
      ProcessOnStateChangeFailedWithRetry onStateChangeFailedWithRetry) {
    this.onStateChange = onStateChange;
    this.onStateChangeFailedWithRetry = onStateChangeFailedWithRetry;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private ProcessOnStateChange onStateChange;
    private int onStateChangeBuildStage;

    ProcessOnStateChange onStateChange() {
      if (onStateChangeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (onStateChangeBuildStage == STAGE_UNINITIALIZED) {
        onStateChangeBuildStage = STAGE_INITIALIZING;
        this.onStateChange = Objects.requireNonNull(onStateChangeInitialize(), "onStateChange");
        onStateChangeBuildStage = STAGE_INITIALIZED;
      }
      return this.onStateChange;
    }

    void onStateChange(ProcessOnStateChange onStateChange) {
      this.onStateChange = onStateChange;
      onStateChangeBuildStage = STAGE_INITIALIZED;
    }
    private ProcessOnStateChangeFailedWithRetry onStateChangeFailedWithRetry;
    private int onStateChangeFailedWithRetryBuildStage;

    ProcessOnStateChangeFailedWithRetry onStateChangeFailedWithRetry() {
      if (onStateChangeFailedWithRetryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (onStateChangeFailedWithRetryBuildStage == STAGE_UNINITIALIZED) {
        onStateChangeFailedWithRetryBuildStage = STAGE_INITIALIZING;
        this.onStateChangeFailedWithRetry = Objects.requireNonNull(onStateChangeFailedWithRetryInitialize(), "onStateChangeFailedWithRetry");
        onStateChangeFailedWithRetryBuildStage = STAGE_INITIALIZED;
      }
      return this.onStateChangeFailedWithRetry;
    }

    void onStateChangeFailedWithRetry(ProcessOnStateChangeFailedWithRetry onStateChangeFailedWithRetry) {
      this.onStateChangeFailedWithRetry = onStateChangeFailedWithRetry;
      onStateChangeFailedWithRetryBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (onStateChangeBuildStage == STAGE_INITIALIZING) attributes.add("onStateChange");
      if (onStateChangeFailedWithRetryBuildStage == STAGE_INITIALIZING) attributes.add("onStateChangeFailedWithRetry");
      return "Cannot build Helper, attribute initializers form cycle" + attributes;
    }
  }

  private ProcessOnStateChange onStateChangeInitialize() {
    return ProcessListener.Helper.super.onStateChange();
  }

  private ProcessOnStateChangeFailedWithRetry onStateChangeFailedWithRetryInitialize() {
    return ProcessListener.Helper.super.onStateChangeFailedWithRetry();
  }

  /**
   * @return The value of the {@code onStateChange} attribute
   */
  @Override
  public ProcessOnStateChange onStateChange() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.onStateChange()
        : this.onStateChange;
  }

  /**
   * @return The value of the {@code onStateChangeFailedWithRetry} attribute
   */
  @Override
  public ProcessOnStateChangeFailedWithRetry onStateChangeFailedWithRetry() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.onStateChangeFailedWithRetry()
        : this.onStateChangeFailedWithRetry;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessListener.Helper#onStateChange() onStateChange} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for onStateChange
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHelper withOnStateChange(ProcessOnStateChange value) {
    if (this.onStateChange == value) return this;
    ProcessOnStateChange newValue = Objects.requireNonNull(value, "onStateChange");
    return new ImmutableHelper(newValue, this.onStateChangeFailedWithRetry);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessListener.Helper#onStateChangeFailedWithRetry() onStateChangeFailedWithRetry} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for onStateChangeFailedWithRetry
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHelper withOnStateChangeFailedWithRetry(ProcessOnStateChangeFailedWithRetry value) {
    if (this.onStateChangeFailedWithRetry == value) return this;
    ProcessOnStateChangeFailedWithRetry newValue = Objects.requireNonNull(value, "onStateChangeFailedWithRetry");
    return new ImmutableHelper(this.onStateChange, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHelper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHelper
        && equalTo((ImmutableHelper) another);
  }

  private boolean equalTo(ImmutableHelper another) {
    return onStateChange.equals(another.onStateChange)
        && onStateChangeFailedWithRetry.equals(another.onStateChangeFailedWithRetry);
  }

  /**
   * Computes a hash code from attributes: {@code onStateChange}, {@code onStateChangeFailedWithRetry}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + onStateChange.hashCode();
    h += (h << 5) + onStateChangeFailedWithRetry.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Helper} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Helper{"
        + "onStateChange=" + onStateChange
        + ", onStateChangeFailedWithRetry=" + onStateChangeFailedWithRetry
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessListener.Helper} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Helper instance
   */
  public static ImmutableHelper copyOf(ProcessListener.Helper instance) {
    if (instance instanceof ImmutableHelper) {
      return (ImmutableHelper) instance;
    }
    return ImmutableHelper.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHelper ImmutableHelper}.
   * @return A new ImmutableHelper builder
   */
  public static ImmutableHelper.Builder builder() {
    return new ImmutableHelper.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHelper ImmutableHelper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder 
      implements ProcessListener.Helper.Builder {
    private ProcessOnStateChange onStateChange;
    private ProcessOnStateChangeFailedWithRetry onStateChangeFailedWithRetry;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Helper} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessListener.Helper instance) {
      Objects.requireNonNull(instance, "instance");
      onStateChange(instance.onStateChange());
      onStateChangeFailedWithRetry(instance.onStateChangeFailedWithRetry());
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessListener.Helper#onStateChange() onStateChange} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ProcessListener.Helper#onStateChange() onStateChange}.</em>
     * @param onStateChange The value for onStateChange 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder onStateChange(ProcessOnStateChange onStateChange) {
      this.onStateChange = Objects.requireNonNull(onStateChange, "onStateChange");
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessListener.Helper#onStateChangeFailedWithRetry() onStateChangeFailedWithRetry} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ProcessListener.Helper#onStateChangeFailedWithRetry() onStateChangeFailedWithRetry}.</em>
     * @param onStateChangeFailedWithRetry The value for onStateChangeFailedWithRetry 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder onStateChangeFailedWithRetry(ProcessOnStateChangeFailedWithRetry onStateChangeFailedWithRetry) {
      this.onStateChangeFailedWithRetry = Objects.requireNonNull(onStateChangeFailedWithRetry, "onStateChangeFailedWithRetry");
      return this;
    }

    /**
     * Builds a new {@link ImmutableHelper ImmutableHelper}.
     * @return An immutable instance of Helper
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHelper build() {
      return new ImmutableHelper(this);
    }
  }
}
