package de.flapdoodle.transition.initlike;

import de.flapdoodle.transition.StateID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link InitListener.TypedListener}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTypedListener.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "InitListener.TypedListener"})
public final class ImmutableTypedListener extends InitListener.TypedListener {
  private final List<InitListener.StateListener<?>> stateReachedListener;
  private final List<InitListener.StateListener<?>> stateTearDownListener;

  private ImmutableTypedListener(
      List<InitListener.StateListener<?>> stateReachedListener,
      List<InitListener.StateListener<?>> stateTearDownListener) {
    this.stateReachedListener = stateReachedListener;
    this.stateTearDownListener = stateTearDownListener;
  }

  /**
   * @return The value of the {@code stateReachedListener} attribute
   */
  @Override
  protected List<InitListener.StateListener<?>> stateReachedListener() {
    return stateReachedListener;
  }

  /**
   * @return The value of the {@code stateTearDownListener} attribute
   */
  @Override
  protected List<InitListener.StateListener<?>> stateTearDownListener() {
    return stateTearDownListener;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InitListener.TypedListener#stateReachedListener() stateReachedListener}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs
  public final ImmutableTypedListener withStateReachedListener(InitListener.StateListener<?>... elements) {
    List<InitListener.StateListener<?>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTypedListener(newValue, this.stateTearDownListener);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InitListener.TypedListener#stateReachedListener() stateReachedListener}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of stateReachedListener elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTypedListener withStateReachedListener(Iterable<? extends InitListener.StateListener<?>> elements) {
    if (this.stateReachedListener == elements) return this;
    List<InitListener.StateListener<?>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTypedListener(newValue, this.stateTearDownListener);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InitListener.TypedListener#stateTearDownListener() stateTearDownListener}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs
  public final ImmutableTypedListener withStateTearDownListener(InitListener.StateListener<?>... elements) {
    List<InitListener.StateListener<?>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTypedListener(this.stateReachedListener, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InitListener.TypedListener#stateTearDownListener() stateTearDownListener}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of stateTearDownListener elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTypedListener withStateTearDownListener(Iterable<? extends InitListener.StateListener<?>> elements) {
    if (this.stateTearDownListener == elements) return this;
    List<InitListener.StateListener<?>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTypedListener(this.stateReachedListener, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTypedListener} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTypedListener
        && equalTo((ImmutableTypedListener) another);
  }

  private boolean equalTo(ImmutableTypedListener another) {
    return stateReachedListener.equals(another.stateReachedListener)
        && stateTearDownListener.equals(another.stateTearDownListener);
  }

  /**
   * Computes a hash code from attributes: {@code stateReachedListener}, {@code stateTearDownListener}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + stateReachedListener.hashCode();
    h += (h << 5) + stateTearDownListener.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TypedListener} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TypedListener{"
        + "stateReachedListener=" + stateReachedListener
        + ", stateTearDownListener=" + stateTearDownListener
        + "}";
  }

  private volatile long lazyInitBitmap;

  private static final long STATE_REACHED_LISTENER_AS_MAP_LAZY_INIT_BIT = 0x1L;

  private Map<StateID<?>, Consumer<?>> stateReachedListenerAsMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link InitListener.TypedListener#stateReachedListenerAsMap() stateReachedListenerAsMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code l.name} attribute
   */
  @Override
  public Map<StateID<?>, Consumer<?>> stateReachedListenerAsMap() {
    if ((lazyInitBitmap & STATE_REACHED_LISTENER_AS_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & STATE_REACHED_LISTENER_AS_MAP_LAZY_INIT_BIT) == 0) {
          this.stateReachedListenerAsMap = Objects.requireNonNull(super.stateReachedListenerAsMap(), "stateReachedListenerAsMap");
          lazyInitBitmap |= STATE_REACHED_LISTENER_AS_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return stateReachedListenerAsMap;
  }

  private static final long STATE_TEAR_DOWN_LISTENER_AS_MAP_LAZY_INIT_BIT = 0x2L;

  private Map<StateID<?>, Consumer<?>> stateTearDownListenerAsMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link InitListener.TypedListener#stateTearDownListenerAsMap() stateTearDownListenerAsMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code l.name} attribute
   */
  @Override
  public Map<StateID<?>, Consumer<?>> stateTearDownListenerAsMap() {
    if ((lazyInitBitmap & STATE_TEAR_DOWN_LISTENER_AS_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & STATE_TEAR_DOWN_LISTENER_AS_MAP_LAZY_INIT_BIT) == 0) {
          this.stateTearDownListenerAsMap = Objects.requireNonNull(super.stateTearDownListenerAsMap(), "stateTearDownListenerAsMap");
          lazyInitBitmap |= STATE_TEAR_DOWN_LISTENER_AS_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return stateTearDownListenerAsMap;
  }

  /**
   * Creates an immutable copy of a {@link InitListener.TypedListener} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TypedListener instance
   */
  public static ImmutableTypedListener copyOf(InitListener.TypedListener instance) {
    if (instance instanceof ImmutableTypedListener) {
      return (ImmutableTypedListener) instance;
    }
    return ImmutableTypedListener.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTypedListener ImmutableTypedListener}.
   * @return A new ImmutableTypedListener builder
   */
  public static ImmutableTypedListener.Builder builder() {
    return new ImmutableTypedListener.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTypedListener ImmutableTypedListener}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder 
      implements InitListener.TypedListener.Builder {
    private List<InitListener.StateListener<?>> stateReachedListener = new ArrayList<InitListener.StateListener<?>>();
    private List<InitListener.StateListener<?>> stateTearDownListener = new ArrayList<InitListener.StateListener<?>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TypedListener} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InitListener.TypedListener instance) {
      Objects.requireNonNull(instance, "instance");
      addAllStateReachedListener(instance.stateReachedListener());
      addAllStateTearDownListener(instance.stateTearDownListener());
      return this;
    }

    /**
     * Adds one element to {@link InitListener.TypedListener#stateReachedListener() stateReachedListener} list.
     * @param element A stateReachedListener element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStateReachedListener(InitListener.StateListener<?> element) {
      this.stateReachedListener.add(Objects.requireNonNull(element, "stateReachedListener element"));
      return this;
    }

    /**
     * Adds elements to {@link InitListener.TypedListener#stateReachedListener() stateReachedListener} list.
     * @param elements An array of stateReachedListener elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs
    public final Builder addStateReachedListener(InitListener.StateListener<?>... elements) {
      for (InitListener.StateListener<?> element : elements) {
        this.stateReachedListener.add(Objects.requireNonNull(element, "stateReachedListener element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link InitListener.TypedListener#stateReachedListener() stateReachedListener} list.
     * @param elements An iterable of stateReachedListener elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stateReachedListener(Iterable<? extends InitListener.StateListener<?>> elements) {
      this.stateReachedListener.clear();
      return addAllStateReachedListener(elements);
    }

    /**
     * Adds elements to {@link InitListener.TypedListener#stateReachedListener() stateReachedListener} list.
     * @param elements An iterable of stateReachedListener elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStateReachedListener(Iterable<? extends InitListener.StateListener<?>> elements) {
      for (InitListener.StateListener<?> element : elements) {
        this.stateReachedListener.add(Objects.requireNonNull(element, "stateReachedListener element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link InitListener.TypedListener#stateTearDownListener() stateTearDownListener} list.
     * @param element A stateTearDownListener element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStateTearDownListener(InitListener.StateListener<?> element) {
      this.stateTearDownListener.add(Objects.requireNonNull(element, "stateTearDownListener element"));
      return this;
    }

    /**
     * Adds elements to {@link InitListener.TypedListener#stateTearDownListener() stateTearDownListener} list.
     * @param elements An array of stateTearDownListener elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs
    public final Builder addStateTearDownListener(InitListener.StateListener<?>... elements) {
      for (InitListener.StateListener<?> element : elements) {
        this.stateTearDownListener.add(Objects.requireNonNull(element, "stateTearDownListener element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link InitListener.TypedListener#stateTearDownListener() stateTearDownListener} list.
     * @param elements An iterable of stateTearDownListener elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stateTearDownListener(Iterable<? extends InitListener.StateListener<?>> elements) {
      this.stateTearDownListener.clear();
      return addAllStateTearDownListener(elements);
    }

    /**
     * Adds elements to {@link InitListener.TypedListener#stateTearDownListener() stateTearDownListener} list.
     * @param elements An iterable of stateTearDownListener elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStateTearDownListener(Iterable<? extends InitListener.StateListener<?>> elements) {
      for (InitListener.StateListener<?> element : elements) {
        this.stateTearDownListener.add(Objects.requireNonNull(element, "stateTearDownListener element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableTypedListener ImmutableTypedListener}.
     * @return An immutable instance of TypedListener
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTypedListener build() {
      return new ImmutableTypedListener(
          createUnmodifiableList(true, stateReachedListener),
          createUnmodifiableList(true, stateTearDownListener));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
