package de.flapdoodle.transition.initlike;

import de.flapdoodle.transition.StateID;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link NamedTypeAndValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNamedTypeAndValue.<T>builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNamedTypeAndValue.<T>of()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "NamedTypeAndValue<T>"})
public final class ImmutableNamedTypeAndValue<T>
    implements NamedTypeAndValue<T> {
  private final StateID<T> type;
  private final T value;

  private ImmutableNamedTypeAndValue(StateID<T> type, T value) {
    this.type = Objects.requireNonNull(type, "type");
    this.value = Objects.requireNonNull(value, "value");
  }

  private ImmutableNamedTypeAndValue(ImmutableNamedTypeAndValue original, StateID<T> type, T value) {
    this.type = type;
    this.value = value;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public StateID<T> type() {
    return type;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public T value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NamedTypeAndValue#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNamedTypeAndValue<T> withType(StateID<T> value) {
    if (this.type == value) return this;
    StateID<T> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableNamedTypeAndValue<T>(this, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NamedTypeAndValue#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNamedTypeAndValue<T> withValue(T value) {
    if (this.value == value) return this;
    T newValue = Objects.requireNonNull(value, "value");
    return new ImmutableNamedTypeAndValue<T>(this, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNamedTypeAndValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNamedTypeAndValue<?>
        && equalTo((ImmutableNamedTypeAndValue<T>) another);
  }

  private boolean equalTo(ImmutableNamedTypeAndValue<T> another) {
    return type.equals(another.type)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NamedTypeAndValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NamedTypeAndValue{"
        + "type=" + type
        + ", value=" + value
        + "}";
  }

  /**
   * Construct a new immutable {@code NamedTypeAndValue} instance.
   * @param type The value for the {@code type} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable NamedTypeAndValue instance
   */
  public static <T> ImmutableNamedTypeAndValue<T> of(StateID<T> type, T value) {
    return new ImmutableNamedTypeAndValue<T>(type, value);
  }

  /**
   * Creates an immutable copy of a {@link NamedTypeAndValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable NamedTypeAndValue instance
   */
  public static <T> ImmutableNamedTypeAndValue<T> copyOf(NamedTypeAndValue<T> instance) {
    if (instance instanceof ImmutableNamedTypeAndValue<?>) {
      return (ImmutableNamedTypeAndValue<T>) instance;
    }
    return ImmutableNamedTypeAndValue.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNamedTypeAndValue ImmutableNamedTypeAndValue}.
   * @param <T> generic parameter T
   * @return A new ImmutableNamedTypeAndValue builder
   */
  public static <T> ImmutableNamedTypeAndValue.Builder<T> builder() {
    return new ImmutableNamedTypeAndValue.Builder<T>();
  }

  /**
   * Builds instances of type {@link ImmutableNamedTypeAndValue ImmutableNamedTypeAndValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder<T> {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private StateID<T> type;
    private T value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NamedTypeAndValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(NamedTypeAndValue<T> instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.type());
      value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link NamedTypeAndValue#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> type(StateID<T> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link NamedTypeAndValue#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> value(T value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNamedTypeAndValue ImmutableNamedTypeAndValue}.
     * @return An immutable instance of NamedTypeAndValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNamedTypeAndValue<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNamedTypeAndValue<T>(null, type, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build NamedTypeAndValue, some of required attributes are not set " + attributes;
    }
  }
}
