package de.flapdoodle.transition;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link StateID}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStateID.<T>builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStateID.<T>of()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "StateID<T>"})
public final class ImmutableStateID<T> implements StateID<T> {
  private final String name;
  private final Class<T> type;

  private ImmutableStateID(String name, Class<T> type) {
    this.name = Objects.requireNonNull(name, "name");
    this.type = Objects.requireNonNull(type, "type");
  }

  private ImmutableStateID(ImmutableStateID original, String name, Class<T> type) {
    this.name = name;
    this.type = type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public Class<T> type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StateID#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStateID<T> withName(String value) {
    if (this.name.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "name");
    return new ImmutableStateID<T>(this, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StateID#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStateID<T> withType(Class<T> value) {
    if (this.type == value) return this;
    Class<T> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableStateID<T>(this, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStateID} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStateID<?>
        && equalTo((ImmutableStateID<T>) another);
  }

  private boolean equalTo(ImmutableStateID<T> another) {
    return name.equals(another.name)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StateID} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StateID{"
        + "name=" + name
        + ", type=" + type
        + "}";
  }

  /**
   * Construct a new immutable {@code StateID} instance.
   * @param name The value for the {@code name} attribute
   * @param type The value for the {@code type} attribute
   * @return An immutable StateID instance
   */
  public static <T> ImmutableStateID<T> of(String name, Class<T> type) {
    return new ImmutableStateID<T>(name, type);
  }

  /**
   * Creates an immutable copy of a {@link StateID} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable StateID instance
   */
  public static <T> ImmutableStateID<T> copyOf(StateID<T> instance) {
    if (instance instanceof ImmutableStateID<?>) {
      return (ImmutableStateID<T>) instance;
    }
    return ImmutableStateID.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStateID ImmutableStateID}.
   * @param <T> generic parameter T
   * @return A new ImmutableStateID builder
   */
  public static <T> ImmutableStateID.Builder<T> builder() {
    return new ImmutableStateID.Builder<T>();
  }

  /**
   * Builds instances of type {@link ImmutableStateID ImmutableStateID}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder<T> {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private Class<T> type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StateID} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(StateID<T> instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      type(instance.type());
      return this;
    }

    /**
     * Initializes the value for the {@link StateID#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StateID#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> type(Class<T> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStateID ImmutableStateID}.
     * @return An immutable instance of StateID
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStateID<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStateID<T>(null, name, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build StateID, some of required attributes are not set " + attributes;
    }
  }
}
