/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.testdoc.ImmutableTemplateReference;
import de.flapdoodle.testdoc.Resources;
import java.io.InputStream;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface TemplateReference {
    @Value.Parameter
    public Class<?> clazz();

    @Value.Parameter
    public String templateName();

    @Value.Lazy
    default public Optional<String> readContent() {
        try {
            return Optional.of(TemplateReference.readContent(this.clazz(), this.templateName()));
        }
        catch (RuntimeException rx) {
            return Optional.empty();
        }
    }

    public static TemplateReference of(Class<?> clazz, String templateName) {
        return ImmutableTemplateReference.of(clazz, templateName);
    }

    public static String readContent(Class<?> clazz, String template) {
        return Resources.read(() -> (InputStream)Preconditions.checkNotNull((Object)clazz.getResourceAsStream(template), (String)"could not get %s for %s", (Object[])new Object[]{template, clazz}));
    }
}

