/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.testdoc.ImmutableReplacements;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.Value;

public abstract class Template {
    private static Pattern VAR_PATTERN = Pattern.compile("(?<all>\\$\\{(?<label>[a-zA-Z0-9\\-_:\\.]+)\\})");

    public static String render(String template, Map<String, String> replacements) {
        return Template.render(template, (String key) -> (String)Preconditions.checkNotNull(replacements.get(key), (String)"could not resolve %s in %s", (Object[])new Object[]{key, replacements.keySet()}));
    }

    public static String render(String template, Map<String, String> replacements, BiFunction<String, Set<String>, String> fallback) {
        return Template.render(template, (String key) -> {
            String replacement = (String)replacements.get(key);
            if (replacement == null) {
                replacement = (String)Preconditions.checkNotNull(fallback.apply((String)key, replacements.keySet()), (String)"fallback return null for %s", (Object[])new Object[]{key});
            }
            return replacement;
        });
    }

    public static String render(String template, Function<String, String> variableLookUp) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = VAR_PATTERN.matcher(template);
        int lastEnd = 0;
        while (matcher.find()) {
            sb.append(template.substring(lastEnd, matcher.start()));
            sb.append(variableLookUp.apply(matcher.group("label")));
            lastEnd = matcher.end();
        }
        sb.append(template.substring(lastEnd));
        return sb.toString();
    }

    @Value.Immutable
    public static interface Replacements {
        public Map<String, String> replacement();

        public static ImmutableReplacements.Builder builder() {
            return ImmutableReplacements.builder();
        }
    }
}

