/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.testdoc.CalledMethod;
import de.flapdoodle.testdoc.End;
import de.flapdoodle.testdoc.HasLine;
import de.flapdoodle.testdoc.Includes;
import de.flapdoodle.testdoc.Line;
import de.flapdoodle.testdoc.Recordings;
import de.flapdoodle.testdoc.Renderer;
import de.flapdoodle.testdoc.ResourceFilter;
import de.flapdoodle.testdoc.Resources;
import de.flapdoodle.testdoc.Stacktraces;
import de.flapdoodle.testdoc.Start;
import de.flapdoodle.testdoc.TabSize;
import de.flapdoodle.testdoc.TemplateReference;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class Recording
implements AfterAllCallback {
    private static final String DEST_DIR_PROPERTY = "de.flapdoodle.testdoc.destination";
    private static final ThreadLocal<BiConsumer<String, String>> templateConsumer = new ThreadLocal();
    private final TemplateReference templateReference;
    private final List<String> testSourceCode;
    private final List<HasLine> lines = new ArrayList<HasLine>();
    private final Map<String, CalledMethod> calledMethod = new LinkedHashMap<String, CalledMethod>();
    private final Map<String, String> classes = new LinkedHashMap<String, String>();
    private final Map<String, String> resources = new LinkedHashMap<String, String>();
    private final Map<String, String> output = new LinkedHashMap<String, String>();
    private final TabSize tabSize;
    private Optional<BiFunction<String, Set<String>, String>> replacementNotFoundFallback = Optional.empty();

    protected Recording(TemplateReference templateReference, List<String> testSourceCode, TabSize tabSize) {
        this.tabSize = tabSize;
        this.templateReference = (TemplateReference)Preconditions.checkNotNull((Object)templateReference, (String)"template name is null", (Object[])new Object[0]);
        this.testSourceCode = new ArrayList<String>((Collection)Preconditions.checkNotNull(testSourceCode, (String)"linesOfCode is null", (Object[])new Object[0]));
    }

    public Recording sourceCodeOf(String label, Class<?> clazz, Includes ... includeOptions) {
        Optional<List<String>> sourceCode = Resources.sourceCodeOf(clazz, this.tabSize, includeOptions);
        Preconditions.checkArgument((boolean)sourceCode.isPresent(), (String)"could not find sourceCode of %s", (Object[])new Object[]{clazz});
        String old = this.classes.put(label, Resources.joinedWithNewLine((Collection<String>)sourceCode.get()));
        Preconditions.checkArgument((old == null ? 1 : 0) != 0, (String)"sourceCodeOf with label %s was already set to %s", (Object[])new Object[]{label, old});
        return this;
    }

    @Deprecated
    public Recording thisMethod(String label) {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        CalledMethod old = this.calledMethod.put(label, CalledMethod.of(currentLine));
        Preconditions.checkArgument((old == null ? 1 : 0) != 0, (String)"method with label %s was already set to %s", (Object[])new Object[]{label, old});
        return this;
    }

    public Recording resource(String label, Class<?> clazz, String resourceName, ResourceFilter ... filters) {
        Optional<String> resource = Resources.resource(clazz, resourceName);
        Preconditions.checkArgument((boolean)resource.isPresent(), (String)"could not find resource of %s:%s", (Object[])new Object[]{clazz, resourceName});
        String old = this.resources.put(label, resource.map(ResourceFilter.join(filters)).get());
        Preconditions.checkArgument((old == null ? 1 : 0) != 0, (String)"resource with label %s was already set to %s", (Object[])new Object[]{label, old});
        return this;
    }

    public Recording replacementNotFoundFallback(BiFunction<String, Set<String>, String> fallback) {
        Preconditions.checkArgument((!this.replacementNotFoundFallback.isPresent() ? 1 : 0) != 0, (String)"already set to: %s", (Object[])new Object[]{this.replacementNotFoundFallback});
        this.replacementNotFoundFallback = Optional.of(fallback);
        return this;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        String renderedTemplate = Renderer.renderTemplate(Recordings.builder().templateReference(this.templateReference).linesOfCode(this.testSourceCode).lines(this.lines).methodsCalled(this.calledMethod).classes(this.classes).resources(this.resources).output(this.output).replacementNotFoundFallback(this.replacementNotFoundFallback).build());
        Recording.writeResult(this.templateReference.templateName(), renderedTemplate);
    }

    protected static void writeResult(String templateName, String renderedTemplate) {
        if (templateConsumer.get() != null) {
            templateConsumer.get().accept(templateName, renderedTemplate);
        } else {
            String destination = System.getProperty(DEST_DIR_PROPERTY);
            if (destination != null) {
                Path output = Paths.get(destination, new String[0]).resolve(templateName);
                try {
                    Files.write(output, renderedTemplate.getBytes(Charset.forName("UTF-8")), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (IOException iox) {
                    throw new RuntimeException("could not write " + output, iox);
                }
            } else {
                System.out.println("de.flapdoodle.testdoc.destination not set");
                System.out.println("---------------------------");
                System.out.println("should write " + templateName);
                System.out.println("---------------------------");
                System.out.println(renderedTemplate);
                System.out.println("---------------------------");
            }
        }
    }

    public void include(Class<?> clazz, Includes ... includeOptions) {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        String label = currentLine.methodName() + "." + clazz.getSimpleName();
        this.sourceCodeOf(label, clazz, includeOptions);
    }

    public void resource(Class<?> clazz, String resourceName, ResourceFilter ... filters) {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        String label = currentLine.methodName() + "." + clazz.getSimpleName() + ":" + resourceName;
        this.resource(label, clazz, resourceName, filters);
    }

    public void output(String label, String content) {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        String scopedLabel = currentLine.methodName() + "." + label;
        String old = this.output.put(scopedLabel, content);
        Preconditions.checkArgument((old == null ? 1 : 0) != 0, (String)"%s already set to %s", (Object[])new Object[]{label, old});
    }

    public void begin() {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        this.lines.add(Start.of(currentLine));
    }

    public void begin(String label) {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        this.lines.add(Start.of(label, currentLine));
    }

    public void end() {
        Line currentLine = Stacktraces.currentLine(Stacktraces.Scope.CallerOfCaller);
        this.lines.add(End.of(currentLine));
    }

    private static BiConsumer<String, String> setTemplateConsumerForInternalUse(BiConsumer<String, String> consumer) {
        BiConsumer<String, String> old = templateConsumer.get();
        templateConsumer.set(consumer);
        return old;
    }

    protected static Consumer<Runnable> runWithTemplateConsumer(BiConsumer<String, String> consumer) {
        return runnable -> {
            BiConsumer<String, String> old = Recording.setTemplateConsumerForInternalUse(consumer);
            try {
                runnable.run();
            }
            finally {
                Recording.setTemplateConsumerForInternalUse(old);
            }
        };
    }
}

