package de.flapdoodle.testdoc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TemplateReference}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTemplateReference.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTemplateReference.of()}.
 */
@Generated(from = "TemplateReference", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableTemplateReference implements TemplateReference {
  private final Class<?> clazz;
  private final String templateName;

  private ImmutableTemplateReference(Class<?> clazz, String templateName) {
    this.clazz = Objects.requireNonNull(clazz, "clazz");
    this.templateName = Objects.requireNonNull(templateName, "templateName");
  }

  private ImmutableTemplateReference(ImmutableTemplateReference original, Class<?> clazz, String templateName) {
    this.clazz = clazz;
    this.templateName = templateName;
  }

  /**
   * @return The value of the {@code clazz} attribute
   */
  @Override
  public Class<?> clazz() {
    return clazz;
  }

  /**
   * @return The value of the {@code templateName} attribute
   */
  @Override
  public String templateName() {
    return templateName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TemplateReference#clazz() clazz} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clazz
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTemplateReference withClazz(Class<?> value) {
    if (this.clazz == value) return this;
    Class<?> newValue = Objects.requireNonNull(value, "clazz");
    return new ImmutableTemplateReference(this, newValue, this.templateName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TemplateReference#templateName() templateName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for templateName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTemplateReference withTemplateName(String value) {
    String newValue = Objects.requireNonNull(value, "templateName");
    if (this.templateName.equals(newValue)) return this;
    return new ImmutableTemplateReference(this, this.clazz, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTemplateReference} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTemplateReference
        && equalTo((ImmutableTemplateReference) another);
  }

  private boolean equalTo(ImmutableTemplateReference another) {
    return clazz.equals(another.clazz)
        && templateName.equals(another.templateName);
  }

  /**
   * Computes a hash code from attributes: {@code clazz}, {@code templateName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clazz.hashCode();
    h += (h << 5) + templateName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TemplateReference} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("TemplateReference{");
    builder.append("clazz=").append(clazz);
    builder.append(", ");
    builder.append("templateName=").append(templateName);
    return builder.append("}").toString();
  }

  private transient volatile long lazyInitBitmap;

  private static final long READ_CONTENT_LAZY_INIT_BIT = 0x1L;

  private transient Optional<String> readContent;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link TemplateReference#readContent() readContent} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code readContent} attribute
   */
  @Override
  public Optional<String> readContent() {
    if ((lazyInitBitmap & READ_CONTENT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & READ_CONTENT_LAZY_INIT_BIT) == 0) {
          this.readContent = Objects.requireNonNull(TemplateReference.super.readContent(), "readContent");
          lazyInitBitmap |= READ_CONTENT_LAZY_INIT_BIT;
        }
      }
    }
    return readContent;
  }

  /**
   * Construct a new immutable {@code TemplateReference} instance.
   * @param clazz The value for the {@code clazz} attribute
   * @param templateName The value for the {@code templateName} attribute
   * @return An immutable TemplateReference instance
   */
  public static ImmutableTemplateReference of(Class<?> clazz, String templateName) {
    return new ImmutableTemplateReference(clazz, templateName);
  }

  /**
   * Creates an immutable copy of a {@link TemplateReference} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TemplateReference instance
   */
  public static ImmutableTemplateReference copyOf(TemplateReference instance) {
    if (instance instanceof ImmutableTemplateReference) {
      return (ImmutableTemplateReference) instance;
    }
    return ImmutableTemplateReference.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTemplateReference ImmutableTemplateReference}.
   * <pre>
   * ImmutableTemplateReference.builder()
   *    .clazz(Class&amp;lt;?&amp;gt;) // required {@link TemplateReference#clazz() clazz}
   *    .templateName(String) // required {@link TemplateReference#templateName() templateName}
   *    .build();
   * </pre>
   * @return A new ImmutableTemplateReference builder
   */
  public static ImmutableTemplateReference.Builder builder() {
    return new ImmutableTemplateReference.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTemplateReference ImmutableTemplateReference}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TemplateReference", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLAZZ = 0x1L;
    private static final long INIT_BIT_TEMPLATE_NAME = 0x2L;
    private long initBits = 0x3L;

    private Class<?> clazz;
    private String templateName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TemplateReference} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TemplateReference instance) {
      Objects.requireNonNull(instance, "instance");
      clazz(instance.clazz());
      templateName(instance.templateName());
      return this;
    }

    /**
     * Initializes the value for the {@link TemplateReference#clazz() clazz} attribute.
     * @param clazz The value for clazz 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clazz(Class<?> clazz) {
      this.clazz = Objects.requireNonNull(clazz, "clazz");
      initBits &= ~INIT_BIT_CLAZZ;
      return this;
    }

    /**
     * Initializes the value for the {@link TemplateReference#templateName() templateName} attribute.
     * @param templateName The value for templateName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder templateName(String templateName) {
      this.templateName = Objects.requireNonNull(templateName, "templateName");
      initBits &= ~INIT_BIT_TEMPLATE_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTemplateReference ImmutableTemplateReference}.
     * @return An immutable instance of TemplateReference
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTemplateReference build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTemplateReference(null, clazz, templateName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLAZZ) != 0) attributes.add("clazz");
      if ((initBits & INIT_BIT_TEMPLATE_NAME) != 0) attributes.add("templateName");
      return "Cannot build TemplateReference, some of required attributes are not set " + attributes;
    }
  }
}
