package de.flapdoodle.testdoc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TabSize}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTabSize.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTabSize.of()}.
 */
@Generated(from = "TabSize", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableTabSize implements TabSize {
  private final int spaces;

  private ImmutableTabSize(int spaces) {
    this.spaces = spaces;
  }

  /**
   * @return The value of the {@code spaces} attribute
   */
  @Override
  public int spaces() {
    return spaces;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TabSize#spaces() spaces} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for spaces
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTabSize withSpaces(int value) {
    if (this.spaces == value) return this;
    return new ImmutableTabSize(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTabSize} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTabSize
        && equalTo((ImmutableTabSize) another);
  }

  private boolean equalTo(ImmutableTabSize another) {
    return spaces == another.spaces;
  }

  /**
   * Computes a hash code from attributes: {@code spaces}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + spaces;
    return h;
  }

  /**
   * Prints the immutable value {@code TabSize} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TabSize{"
        + "spaces=" + spaces
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long AS_SPACES_LAZY_INIT_BIT = 0x1L;

  private transient String asSpaces;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link TabSize#asSpaces() asSpaces} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code asSpaces} attribute
   */
  @Override
  public String asSpaces() {
    if ((lazyInitBitmap & AS_SPACES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & AS_SPACES_LAZY_INIT_BIT) == 0) {
          this.asSpaces = Objects.requireNonNull(TabSize.super.asSpaces(), "asSpaces");
          lazyInitBitmap |= AS_SPACES_LAZY_INIT_BIT;
        }
      }
    }
    return asSpaces;
  }

  /**
   * Construct a new immutable {@code TabSize} instance.
   * @param spaces The value for the {@code spaces} attribute
   * @return An immutable TabSize instance
   */
  public static ImmutableTabSize of(int spaces) {
    return new ImmutableTabSize(spaces);
  }

  /**
   * Creates an immutable copy of a {@link TabSize} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TabSize instance
   */
  public static ImmutableTabSize copyOf(TabSize instance) {
    if (instance instanceof ImmutableTabSize) {
      return (ImmutableTabSize) instance;
    }
    return ImmutableTabSize.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTabSize ImmutableTabSize}.
   * <pre>
   * ImmutableTabSize.builder()
   *    .spaces(int) // required {@link TabSize#spaces() spaces}
   *    .build();
   * </pre>
   * @return A new ImmutableTabSize builder
   */
  public static ImmutableTabSize.Builder builder() {
    return new ImmutableTabSize.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTabSize ImmutableTabSize}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TabSize", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACES = 0x1L;
    private long initBits = 0x1L;

    private int spaces;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TabSize} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TabSize instance) {
      Objects.requireNonNull(instance, "instance");
      spaces(instance.spaces());
      return this;
    }

    /**
     * Initializes the value for the {@link TabSize#spaces() spaces} attribute.
     * @param spaces The value for spaces 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaces(int spaces) {
      this.spaces = spaces;
      initBits &= ~INIT_BIT_SPACES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTabSize ImmutableTabSize}.
     * @return An immutable instance of TabSize
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTabSize build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTabSize(spaces);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACES) != 0) attributes.add("spaces");
      return "Cannot build TabSize, some of required attributes are not set " + attributes;
    }
  }
}
