package de.flapdoodle.testdoc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Start}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStart.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStart.of()}.
 */
@Generated(from = "Start", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableStart implements Start {
  private final Line line;
  private final String label;

  private ImmutableStart(Line line) {
    this.line = Objects.requireNonNull(line, "line");
    this.label = null;
  }

  private ImmutableStart(Line line, String label) {
    this.line = line;
    this.label = label;
  }

  /**
   * @return The value of the {@code line} attribute
   */
  @Override
  public Line line() {
    return line;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @Override
  public Optional<String> label() {
    return Optional.ofNullable(label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Start#line() line} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for line
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStart withLine(Line value) {
    if (this.line == value) return this;
    Line newValue = Objects.requireNonNull(value, "line");
    return new ImmutableStart(newValue, this.label);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Start#label() label} attribute.
   * @param value The value for label
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStart withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (Objects.equals(this.label, newValue)) return this;
    return new ImmutableStart(this.line, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Start#label() label} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for label
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStart withLabel(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.label, value)) return this;
    return new ImmutableStart(this.line, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStart} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStart
        && equalTo((ImmutableStart) another);
  }

  private boolean equalTo(ImmutableStart another) {
    return line.equals(another.line)
        && Objects.equals(label, another.label);
  }

  /**
   * Computes a hash code from attributes: {@code line}, {@code label}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + line.hashCode();
    h += (h << 5) + Objects.hashCode(label);
    return h;
  }

  /**
   * Prints the immutable value {@code Start} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Start{");
    builder.append("line=").append(line);
    if (label != null) {
      builder.append(", ");
      builder.append("label=").append(label);
    }
    return builder.append("}").toString();
  }

  /**
   * Construct a new immutable {@code Start} instance.
   * @param line The value for the {@code line} attribute
   * @return An immutable Start instance
   */
  public static ImmutableStart of(Line line) {
    return new ImmutableStart(line);
  }

  /**
   * Creates an immutable copy of a {@link Start} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Start instance
   */
  public static ImmutableStart copyOf(Start instance) {
    if (instance instanceof ImmutableStart) {
      return (ImmutableStart) instance;
    }
    return ImmutableStart.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStart ImmutableStart}.
   * <pre>
   * ImmutableStart.builder()
   *    .line(de.flapdoodle.testdoc.Line) // required {@link Start#line() line}
   *    .label(String) // optional {@link Start#label() label}
   *    .build();
   * </pre>
   * @return A new ImmutableStart builder
   */
  public static ImmutableStart.Builder builder() {
    return new ImmutableStart.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStart ImmutableStart}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Start", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_LINE = 0x1L;
    private long initBits = 0x1L;

    private Line line;
    private String label;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.testdoc.Start} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Start instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.testdoc.HasLine} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasLine instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof Start) {
        Start instance = (Start) object;
        if ((bits & 0x1L) == 0) {
          line(instance.line());
          bits |= 0x1L;
        }
        Optional<String> labelOptional = instance.label();
        if (labelOptional.isPresent()) {
          label(labelOptional);
        }
      }
      if (object instanceof HasLine) {
        HasLine instance = (HasLine) object;
        if ((bits & 0x1L) == 0) {
          line(instance.line());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Start#line() line} attribute.
     * @param line The value for line 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder line(Line line) {
      this.line = Objects.requireNonNull(line, "line");
      initBits &= ~INIT_BIT_LINE;
      return this;
    }

    /**
     * Initializes the optional value {@link Start#label() label} to label.
     * @param label The value for label
     * @return {@code this} builder for chained invocation
     */
    public final Builder label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      return this;
    }

    /**
     * Initializes the optional value {@link Start#label() label} to label.
     * @param label The value for label
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder label(Optional<String> label) {
      this.label = label.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStart ImmutableStart}.
     * @return An immutable instance of Start
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStart build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStart(line, label);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LINE) != 0) attributes.add("line");
      return "Cannot build Start, some of required attributes are not set " + attributes;
    }
  }
}
