package de.flapdoodle.testdoc;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Template.Replacements}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReplacements.builder()}.
 */
@Generated(from = "Template.Replacements", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableReplacements implements Template.Replacements {
  private final Map<String, String> replacement;

  private ImmutableReplacements(Map<String, String> replacement) {
    this.replacement = replacement;
  }

  /**
   * @return The value of the {@code replacement} attribute
   */
  @Override
  public Map<String, String> replacement() {
    return replacement;
  }

  /**
   * Copy the current immutable object by replacing the {@link Template.Replacements#replacement() replacement} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the replacement map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReplacements withReplacement(Map<String, ? extends String> entries) {
    if (this.replacement == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableReplacements(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReplacements} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReplacements
        && equalTo((ImmutableReplacements) another);
  }

  private boolean equalTo(ImmutableReplacements another) {
    return replacement.equals(another.replacement);
  }

  /**
   * Computes a hash code from attributes: {@code replacement}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + replacement.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Replacements} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Replacements{"
        + "replacement=" + replacement
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Template.Replacements} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Replacements instance
   */
  public static ImmutableReplacements copyOf(Template.Replacements instance) {
    if (instance instanceof ImmutableReplacements) {
      return (ImmutableReplacements) instance;
    }
    return ImmutableReplacements.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReplacements ImmutableReplacements}.
   * <pre>
   * ImmutableReplacements.builder()
   *    .putReplacement|putAllReplacement(String =&gt; String) // {@link Template.Replacements#replacement() replacement} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableReplacements builder
   */
  public static ImmutableReplacements.Builder builder() {
    return new ImmutableReplacements.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReplacements ImmutableReplacements}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Template.Replacements", generator = "Immutables")
  public static final class Builder {
    private Map<String, String> replacement = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Replacements} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Template.Replacements instance) {
      Objects.requireNonNull(instance, "instance");
      putAllReplacement(instance.replacement());
      return this;
    }

    /**
     * Put one entry to the {@link Template.Replacements#replacement() replacement} map.
     * @param key The key in the replacement map
     * @param value The associated value in the replacement map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putReplacement(String key, String value) {
      this.replacement.put(
          Objects.requireNonNull(key, "replacement key"),
          Objects.requireNonNull(value, "replacement value"));
      return this;
    }

    /**
     * Put one entry to the {@link Template.Replacements#replacement() replacement} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putReplacement(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.replacement.put(
          Objects.requireNonNull(k, "replacement key"),
          Objects.requireNonNull(v, "replacement value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Template.Replacements#replacement() replacement} map. Nulls are not permitted
     * @param entries The entries that will be added to the replacement map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder replacement(Map<String, ? extends String> entries) {
      this.replacement.clear();
      return putAllReplacement(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Template.Replacements#replacement() replacement} map. Nulls are not permitted
     * @param entries The entries that will be added to the replacement map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllReplacement(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.replacement.put(
            Objects.requireNonNull(k, "replacement key"),
            Objects.requireNonNull(v, "replacement value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableReplacements ImmutableReplacements}.
     * @return An immutable instance of Replacements
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReplacements build() {
      return new ImmutableReplacements(createUnmodifiableMap(false, false, replacement));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
