package de.flapdoodle.testdoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Recordings}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRecordings.builder()}.
 */
@Generated(from = "Recordings", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableRecordings implements Recordings {
  private final TemplateReference templateReference;
  private final List<String> linesOfCode;
  private final List<HasLine> lines;
  private final Map<String, CalledMethod> methodsCalled;
  private final Map<String, String> classes;
  private final Map<String, String> resources;
  private final Map<String, String> output;
  private final BiFunction<String, Set<String>, String> replacementNotFoundFallback;

  private ImmutableRecordings(
      TemplateReference templateReference,
      List<String> linesOfCode,
      List<HasLine> lines,
      Map<String, CalledMethod> methodsCalled,
      Map<String, String> classes,
      Map<String, String> resources,
      Map<String, String> output,
      BiFunction<String, Set<String>, String> replacementNotFoundFallback) {
    this.templateReference = templateReference;
    this.linesOfCode = linesOfCode;
    this.lines = lines;
    this.methodsCalled = methodsCalled;
    this.classes = classes;
    this.resources = resources;
    this.output = output;
    this.replacementNotFoundFallback = replacementNotFoundFallback;
  }

  /**
   * @return The value of the {@code templateReference} attribute
   */
  @Override
  public TemplateReference templateReference() {
    return templateReference;
  }

  /**
   * @return The value of the {@code linesOfCode} attribute
   */
  @Override
  public List<String> linesOfCode() {
    return linesOfCode;
  }

  /**
   * @return The value of the {@code lines} attribute
   */
  @Override
  public List<HasLine> lines() {
    return lines;
  }

  /**
   * @return The value of the {@code methodsCalled} attribute
   */
  @Override
  public Map<String, CalledMethod> methodsCalled() {
    return methodsCalled;
  }

  /**
   * @return The value of the {@code classes} attribute
   */
  @Override
  public Map<String, String> classes() {
    return classes;
  }

  /**
   * @return The value of the {@code resources} attribute
   */
  @Override
  public Map<String, String> resources() {
    return resources;
  }

  /**
   * @return The value of the {@code output} attribute
   */
  @Override
  public Map<String, String> output() {
    return output;
  }

  /**
   * @return The value of the {@code replacementNotFoundFallback} attribute
   */
  @Override
  public Optional<BiFunction<String, Set<String>, String>> replacementNotFoundFallback() {
    return Optional.ofNullable(replacementNotFoundFallback);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Recordings#templateReference() templateReference} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for templateReference
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecordings withTemplateReference(TemplateReference value) {
    if (this.templateReference == value) return this;
    TemplateReference newValue = Objects.requireNonNull(value, "templateReference");
    return new ImmutableRecordings(
        newValue,
        this.linesOfCode,
        this.lines,
        this.methodsCalled,
        this.classes,
        this.resources,
        this.output,
        this.replacementNotFoundFallback);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Recordings#linesOfCode() linesOfCode}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRecordings withLinesOfCode(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableRecordings(
        this.templateReference,
        newValue,
        this.lines,
        this.methodsCalled,
        this.classes,
        this.resources,
        this.output,
        this.replacementNotFoundFallback);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Recordings#linesOfCode() linesOfCode}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of linesOfCode elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRecordings withLinesOfCode(Iterable<String> elements) {
    if (this.linesOfCode == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableRecordings(
        this.templateReference,
        newValue,
        this.lines,
        this.methodsCalled,
        this.classes,
        this.resources,
        this.output,
        this.replacementNotFoundFallback);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Recordings#lines() lines}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRecordings withLines(HasLine... elements) {
    List<HasLine> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableRecordings(
        this.templateReference,
        this.linesOfCode,
        newValue,
        this.methodsCalled,
        this.classes,
        this.resources,
        this.output,
        this.replacementNotFoundFallback);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Recordings#lines() lines}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of lines elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRecordings withLines(Iterable<? extends HasLine> elements) {
    if (this.lines == elements) return this;
    List<HasLine> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableRecordings(
        this.templateReference,
        this.linesOfCode,
        newValue,
        this.methodsCalled,
        this.classes,
        this.resources,
        this.output,
        this.replacementNotFoundFallback);
  }

  /**
   * Copy the current immutable object by replacing the {@link Recordings#methodsCalled() methodsCalled} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the methodsCalled map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRecordings withMethodsCalled(Map<String, ? extends CalledMethod> entries) {
    if (this.methodsCalled == entries) return this;
    Map<String, CalledMethod> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableRecordings(
        this.templateReference,
        this.linesOfCode,
        this.lines,
        newValue,
        this.classes,
        this.resources,
        this.output,
        this.replacementNotFoundFallback);
  }

  /**
   * Copy the current immutable object by replacing the {@link Recordings#classes() classes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the classes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRecordings withClasses(Map<String, ? extends String> entries) {
    if (this.classes == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableRecordings(
        this.templateReference,
        this.linesOfCode,
        this.lines,
        this.methodsCalled,
        newValue,
        this.resources,
        this.output,
        this.replacementNotFoundFallback);
  }

  /**
   * Copy the current immutable object by replacing the {@link Recordings#resources() resources} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the resources map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRecordings withResources(Map<String, ? extends String> entries) {
    if (this.resources == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableRecordings(
        this.templateReference,
        this.linesOfCode,
        this.lines,
        this.methodsCalled,
        this.classes,
        newValue,
        this.output,
        this.replacementNotFoundFallback);
  }

  /**
   * Copy the current immutable object by replacing the {@link Recordings#output() output} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the output map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRecordings withOutput(Map<String, ? extends String> entries) {
    if (this.output == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableRecordings(
        this.templateReference,
        this.linesOfCode,
        this.lines,
        this.methodsCalled,
        this.classes,
        this.resources,
        newValue,
        this.replacementNotFoundFallback);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Recordings#replacementNotFoundFallback() replacementNotFoundFallback} attribute.
   * @param value The value for replacementNotFoundFallback
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRecordings withReplacementNotFoundFallback(BiFunction<String, Set<String>, String> value) {
    BiFunction<String, Set<String>, String> newValue = Objects.requireNonNull(value, "replacementNotFoundFallback");
    if (this.replacementNotFoundFallback == newValue) return this;
    return new ImmutableRecordings(
        this.templateReference,
        this.linesOfCode,
        this.lines,
        this.methodsCalled,
        this.classes,
        this.resources,
        this.output,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Recordings#replacementNotFoundFallback() replacementNotFoundFallback} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for replacementNotFoundFallback
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableRecordings withReplacementNotFoundFallback(Optional<? extends BiFunction<String, Set<String>, String>> optional) {
    BiFunction<String, Set<String>, String> value = optional.orElse(null);
    if (this.replacementNotFoundFallback == value) return this;
    return new ImmutableRecordings(
        this.templateReference,
        this.linesOfCode,
        this.lines,
        this.methodsCalled,
        this.classes,
        this.resources,
        this.output,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRecordings} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRecordings
        && equalTo((ImmutableRecordings) another);
  }

  private boolean equalTo(ImmutableRecordings another) {
    return templateReference.equals(another.templateReference)
        && linesOfCode.equals(another.linesOfCode)
        && lines.equals(another.lines)
        && methodsCalled.equals(another.methodsCalled)
        && classes.equals(another.classes)
        && resources.equals(another.resources)
        && output.equals(another.output)
        && Objects.equals(replacementNotFoundFallback, another.replacementNotFoundFallback);
  }

  /**
   * Computes a hash code from attributes: {@code templateReference}, {@code linesOfCode}, {@code lines}, {@code methodsCalled}, {@code classes}, {@code resources}, {@code output}, {@code replacementNotFoundFallback}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + templateReference.hashCode();
    h += (h << 5) + linesOfCode.hashCode();
    h += (h << 5) + lines.hashCode();
    h += (h << 5) + methodsCalled.hashCode();
    h += (h << 5) + classes.hashCode();
    h += (h << 5) + resources.hashCode();
    h += (h << 5) + output.hashCode();
    h += (h << 5) + Objects.hashCode(replacementNotFoundFallback);
    return h;
  }

  /**
   * Prints the immutable value {@code Recordings} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Recordings{");
    builder.append("templateReference=").append(templateReference);
    builder.append(", ");
    builder.append("linesOfCode=").append(linesOfCode);
    builder.append(", ");
    builder.append("lines=").append(lines);
    builder.append(", ");
    builder.append("methodsCalled=").append(methodsCalled);
    builder.append(", ");
    builder.append("classes=").append(classes);
    builder.append(", ");
    builder.append("resources=").append(resources);
    builder.append(", ");
    builder.append("output=").append(output);
    if (replacementNotFoundFallback != null) {
      builder.append(", ");
      builder.append("replacementNotFoundFallback=").append(replacementNotFoundFallback);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link Recordings} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Recordings instance
   */
  public static ImmutableRecordings copyOf(Recordings instance) {
    if (instance instanceof ImmutableRecordings) {
      return (ImmutableRecordings) instance;
    }
    return ImmutableRecordings.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRecordings ImmutableRecordings}.
   * <pre>
   * ImmutableRecordings.builder()
   *    .templateReference(de.flapdoodle.testdoc.TemplateReference) // required {@link Recordings#templateReference() templateReference}
   *    .addLinesOfCode|addAllLinesOfCode(String) // {@link Recordings#linesOfCode() linesOfCode} elements
   *    .addLines|addAllLines(de.flapdoodle.testdoc.HasLine) // {@link Recordings#lines() lines} elements
   *    .putMethodsCalled|putAllMethodsCalled(String =&gt; de.flapdoodle.testdoc.CalledMethod) // {@link Recordings#methodsCalled() methodsCalled} mappings
   *    .putClasses|putAllClasses(String =&gt; String) // {@link Recordings#classes() classes} mappings
   *    .putResources|putAllResources(String =&gt; String) // {@link Recordings#resources() resources} mappings
   *    .putOutput|putAllOutput(String =&gt; String) // {@link Recordings#output() output} mappings
   *    .replacementNotFoundFallback(function.BiFunction&amp;lt;String, Set&amp;lt;String&amp;gt;, String&amp;gt;) // optional {@link Recordings#replacementNotFoundFallback() replacementNotFoundFallback}
   *    .build();
   * </pre>
   * @return A new ImmutableRecordings builder
   */
  public static ImmutableRecordings.Builder builder() {
    return new ImmutableRecordings.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRecordings ImmutableRecordings}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Recordings", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TEMPLATE_REFERENCE = 0x1L;
    private long initBits = 0x1L;

    private TemplateReference templateReference;
    private List<String> linesOfCode = new ArrayList<String>();
    private List<HasLine> lines = new ArrayList<HasLine>();
    private Map<String, CalledMethod> methodsCalled = new LinkedHashMap<String, CalledMethod>();
    private Map<String, String> classes = new LinkedHashMap<String, String>();
    private Map<String, String> resources = new LinkedHashMap<String, String>();
    private Map<String, String> output = new LinkedHashMap<String, String>();
    private BiFunction<String, Set<String>, String> replacementNotFoundFallback;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Recordings} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Recordings instance) {
      Objects.requireNonNull(instance, "instance");
      templateReference(instance.templateReference());
      addAllLinesOfCode(instance.linesOfCode());
      addAllLines(instance.lines());
      putAllMethodsCalled(instance.methodsCalled());
      putAllClasses(instance.classes());
      putAllResources(instance.resources());
      putAllOutput(instance.output());
      Optional<BiFunction<String, Set<String>, String>> replacementNotFoundFallbackOptional = instance.replacementNotFoundFallback();
      if (replacementNotFoundFallbackOptional.isPresent()) {
        replacementNotFoundFallback(replacementNotFoundFallbackOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Recordings#templateReference() templateReference} attribute.
     * @param templateReference The value for templateReference 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder templateReference(TemplateReference templateReference) {
      this.templateReference = Objects.requireNonNull(templateReference, "templateReference");
      initBits &= ~INIT_BIT_TEMPLATE_REFERENCE;
      return this;
    }

    /**
     * Adds one element to {@link Recordings#linesOfCode() linesOfCode} list.
     * @param element A linesOfCode element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLinesOfCode(String element) {
      this.linesOfCode.add(Objects.requireNonNull(element, "linesOfCode element"));
      return this;
    }

    /**
     * Adds elements to {@link Recordings#linesOfCode() linesOfCode} list.
     * @param elements An array of linesOfCode elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLinesOfCode(String... elements) {
      for (String element : elements) {
        this.linesOfCode.add(Objects.requireNonNull(element, "linesOfCode element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Recordings#linesOfCode() linesOfCode} list.
     * @param elements An iterable of linesOfCode elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder linesOfCode(Iterable<String> elements) {
      this.linesOfCode.clear();
      return addAllLinesOfCode(elements);
    }

    /**
     * Adds elements to {@link Recordings#linesOfCode() linesOfCode} list.
     * @param elements An iterable of linesOfCode elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLinesOfCode(Iterable<String> elements) {
      for (String element : elements) {
        this.linesOfCode.add(Objects.requireNonNull(element, "linesOfCode element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Recordings#lines() lines} list.
     * @param element A lines element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLines(HasLine element) {
      this.lines.add(Objects.requireNonNull(element, "lines element"));
      return this;
    }

    /**
     * Adds elements to {@link Recordings#lines() lines} list.
     * @param elements An array of lines elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLines(HasLine... elements) {
      for (HasLine element : elements) {
        this.lines.add(Objects.requireNonNull(element, "lines element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Recordings#lines() lines} list.
     * @param elements An iterable of lines elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lines(Iterable<? extends HasLine> elements) {
      this.lines.clear();
      return addAllLines(elements);
    }

    /**
     * Adds elements to {@link Recordings#lines() lines} list.
     * @param elements An iterable of lines elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLines(Iterable<? extends HasLine> elements) {
      for (HasLine element : elements) {
        this.lines.add(Objects.requireNonNull(element, "lines element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link Recordings#methodsCalled() methodsCalled} map.
     * @param key The key in the methodsCalled map
     * @param value The associated value in the methodsCalled map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putMethodsCalled(String key, CalledMethod value) {
      this.methodsCalled.put(
          Objects.requireNonNull(key, "methodsCalled key"),
          Objects.requireNonNull(value, "methodsCalled value"));
      return this;
    }

    /**
     * Put one entry to the {@link Recordings#methodsCalled() methodsCalled} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putMethodsCalled(Map.Entry<String, ? extends CalledMethod> entry) {
      String k = entry.getKey();
      CalledMethod v = entry.getValue();
      this.methodsCalled.put(
          Objects.requireNonNull(k, "methodsCalled key"),
          Objects.requireNonNull(v, "methodsCalled value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Recordings#methodsCalled() methodsCalled} map. Nulls are not permitted
     * @param entries The entries that will be added to the methodsCalled map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder methodsCalled(Map<String, ? extends CalledMethod> entries) {
      this.methodsCalled.clear();
      return putAllMethodsCalled(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Recordings#methodsCalled() methodsCalled} map. Nulls are not permitted
     * @param entries The entries that will be added to the methodsCalled map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllMethodsCalled(Map<String, ? extends CalledMethod> entries) {
      for (Map.Entry<String, ? extends CalledMethod> e : entries.entrySet()) {
        String k = e.getKey();
        CalledMethod v = e.getValue();
        this.methodsCalled.put(
            Objects.requireNonNull(k, "methodsCalled key"),
            Objects.requireNonNull(v, "methodsCalled value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link Recordings#classes() classes} map.
     * @param key The key in the classes map
     * @param value The associated value in the classes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putClasses(String key, String value) {
      this.classes.put(
          Objects.requireNonNull(key, "classes key"),
          Objects.requireNonNull(value, "classes value"));
      return this;
    }

    /**
     * Put one entry to the {@link Recordings#classes() classes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putClasses(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.classes.put(
          Objects.requireNonNull(k, "classes key"),
          Objects.requireNonNull(v, "classes value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Recordings#classes() classes} map. Nulls are not permitted
     * @param entries The entries that will be added to the classes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder classes(Map<String, ? extends String> entries) {
      this.classes.clear();
      return putAllClasses(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Recordings#classes() classes} map. Nulls are not permitted
     * @param entries The entries that will be added to the classes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllClasses(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.classes.put(
            Objects.requireNonNull(k, "classes key"),
            Objects.requireNonNull(v, "classes value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link Recordings#resources() resources} map.
     * @param key The key in the resources map
     * @param value The associated value in the resources map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putResources(String key, String value) {
      this.resources.put(
          Objects.requireNonNull(key, "resources key"),
          Objects.requireNonNull(value, "resources value"));
      return this;
    }

    /**
     * Put one entry to the {@link Recordings#resources() resources} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putResources(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.resources.put(
          Objects.requireNonNull(k, "resources key"),
          Objects.requireNonNull(v, "resources value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Recordings#resources() resources} map. Nulls are not permitted
     * @param entries The entries that will be added to the resources map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(Map<String, ? extends String> entries) {
      this.resources.clear();
      return putAllResources(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Recordings#resources() resources} map. Nulls are not permitted
     * @param entries The entries that will be added to the resources map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllResources(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.resources.put(
            Objects.requireNonNull(k, "resources key"),
            Objects.requireNonNull(v, "resources value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link Recordings#output() output} map.
     * @param key The key in the output map
     * @param value The associated value in the output map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putOutput(String key, String value) {
      this.output.put(
          Objects.requireNonNull(key, "output key"),
          Objects.requireNonNull(value, "output value"));
      return this;
    }

    /**
     * Put one entry to the {@link Recordings#output() output} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putOutput(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.output.put(
          Objects.requireNonNull(k, "output key"),
          Objects.requireNonNull(v, "output value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Recordings#output() output} map. Nulls are not permitted
     * @param entries The entries that will be added to the output map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder output(Map<String, ? extends String> entries) {
      this.output.clear();
      return putAllOutput(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Recordings#output() output} map. Nulls are not permitted
     * @param entries The entries that will be added to the output map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllOutput(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.output.put(
            Objects.requireNonNull(k, "output key"),
            Objects.requireNonNull(v, "output value"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Recordings#replacementNotFoundFallback() replacementNotFoundFallback} to replacementNotFoundFallback.
     * @param replacementNotFoundFallback The value for replacementNotFoundFallback
     * @return {@code this} builder for chained invocation
     */
    public final Builder replacementNotFoundFallback(BiFunction<String, Set<String>, String> replacementNotFoundFallback) {
      this.replacementNotFoundFallback = Objects.requireNonNull(replacementNotFoundFallback, "replacementNotFoundFallback");
      return this;
    }

    /**
     * Initializes the optional value {@link Recordings#replacementNotFoundFallback() replacementNotFoundFallback} to replacementNotFoundFallback.
     * @param replacementNotFoundFallback The value for replacementNotFoundFallback
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder replacementNotFoundFallback(Optional<? extends BiFunction<String, Set<String>, String>> replacementNotFoundFallback) {
      this.replacementNotFoundFallback = replacementNotFoundFallback.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRecordings ImmutableRecordings}.
     * @return An immutable instance of Recordings
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRecordings build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRecordings(
          templateReference,
          createUnmodifiableList(true, linesOfCode),
          createUnmodifiableList(true, lines),
          createUnmodifiableMap(false, false, methodsCalled),
          createUnmodifiableMap(false, false, classes),
          createUnmodifiableMap(false, false, resources),
          createUnmodifiableMap(false, false, output),
          replacementNotFoundFallback);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TEMPLATE_REFERENCE) != 0) attributes.add("templateReference");
      return "Cannot build Recordings, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
